/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.context.ProgramContextAction;
import ghidra.app.context.ProgramSymbolActionContext;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.HelpLocation;
import java.awt.Component;

class RevertThunkFunctionAction
extends ProgramContextAction {
    FunctionPlugin funcPlugin;

    public RevertThunkFunctionAction(FunctionPlugin plugin) {
        super("Revert Thunk Function", plugin.getName());
        this.funcPlugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Function", "Revert Thunk Function..."}, null, "FunctionThunk"));
        this.setHelpLocation(new HelpLocation("FunctionPlugin", "ThunkFunctions"));
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ProgramActionContext context) {
        Function func;
        Program program = context.getProgram();
        FunctionManager functionMgr = program.getFunctionManager();
        if (context instanceof ListingActionContext) {
            ListingActionContext listingContext = (ListingActionContext)context;
            func = functionMgr.getFunctionAt(listingContext.getAddress());
        } else if (context instanceof ProgramSymbolActionContext) {
            ProgramSymbolActionContext symbolContext = (ProgramSymbolActionContext)context;
            Symbol symbol = symbolContext.getFirstSymbol();
            if (symbol == null) {
                return;
            }
            func = (Function)symbol.getObject();
        } else {
            throw new RuntimeException("Invalid context for action");
        }
        if (func == null || !func.isThunk()) {
            return;
        }
        int resp = OptionDialog.showYesNoDialog((Component)this.funcPlugin.getTool().getActiveWindow(), (String)"Revert Thunk Confirmation", (String)("Do you wish to revert function '" + func.getName() + "' to a non-thunk Function?"));
        if (resp != 1) {
            return;
        }
        this.funcPlugin.getTool().execute("Revert Thunk", (DomainObject)program, () -> func.setThunkedFunction(null));
    }

    @Override
    protected boolean isEnabledForContext(ProgramActionContext context) {
        Function func;
        Program program = context.getProgram();
        if (program == null) {
            return false;
        }
        FunctionManager functionMgr = program.getFunctionManager();
        if (context instanceof ListingActionContext) {
            ListingActionContext listingContext = (ListingActionContext)context;
            func = functionMgr.getFunctionAt(listingContext.getAddress());
        } else if (context instanceof ProgramSymbolActionContext) {
            ProgramSymbolActionContext symbolContext = (ProgramSymbolActionContext)context;
            if (symbolContext.getSymbolCount() != 1) {
                return false;
            }
            Symbol s = symbolContext.getFirstSymbol();
            if (s == null || s.getSymbolType() != SymbolType.FUNCTION) {
                return false;
            }
            func = (Function)s.getObject();
        } else {
            return false;
        }
        return func != null && func.isThunk();
    }
}

