/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.thread;

import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.info.TraceObjectInterfaceUtils;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class DBTraceObjectThread
implements TraceObjectThread,
DBTraceObjectInterface {
    private final DBTraceObject object;
    private final ThreadChangeTranslator translator;

    public DBTraceObjectThread(DBTraceObject object) {
        this.object = object;
        this.translator = new ThreadChangeTranslator(this, object, this);
    }

    @Override
    public DBTraceObject getObject() {
        return this.object;
    }

    @Override
    public Trace getTrace() {
        return this.object.getTrace();
    }

    @Override
    public long getKey() {
        return this.object.getKey();
    }

    @Override
    public String getPath() {
        return this.object.getCanonicalPath().toString();
    }

    @Override
    public String getName(long snap) {
        return TraceObjectInterfaceUtils.getValue(this.object, snap, "_display", String.class, "");
    }

    @Override
    public void setName(Lifespan lifespan, String name) {
        this.object.setValue(lifespan, "_display", name);
    }

    @Override
    public void setName(long snap, String name) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setName(Lifespan.nowOn(snap), name);
        }
    }

    @Override
    public void setComment(long snap, String comment) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(Lifespan.nowOn(snap), "_comment", comment);
        }
    }

    @Override
    public String getComment(long snap) {
        return TraceObjectInterfaceUtils.getValue(this.object, snap, "_comment", String.class, "");
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(Lifespan.ALL);
        }
    }

    @Override
    public void remove(long snap) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(Lifespan.nowOn(snap));
        }
    }

    @Override
    public boolean isValid(long snap) {
        return this.object.isAlive(snap);
    }

    @Override
    public boolean isAlive(Lifespan span) {
        return this.object.isAlive(span);
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        return this.translator.translate(rec);
    }

    protected class ThreadChangeTranslator
    extends DBTraceObjectInterface.Translator<TraceThread> {
        private static final Map<TraceObjectSchema, Set<String>> KEYS_BY_SCHEMA = new WeakHashMap<TraceObjectSchema, Set<String>>();
        private final Set<String> keys;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ThreadChangeTranslator(DBTraceObjectThread this$0, DBTraceObject object, TraceThread iface) {
            super(null, object, iface);
            TraceObjectSchema schema = object.getSchema();
            Map<TraceObjectSchema, Set<String>> map = KEYS_BY_SCHEMA;
            synchronized (map) {
                this.keys = KEYS_BY_SCHEMA.computeIfAbsent(schema, s -> Set.of(s.checkAliasedAttribute("_comment"), s.checkAliasedAttribute("_display")));
            }
        }

        @Override
        protected TraceEvent<TraceThread, Void> getAddedType() {
            return TraceEvents.THREAD_ADDED;
        }

        @Override
        protected TraceEvent<TraceThread, Lifespan> getLifespanChangedType() {
            return TraceEvents.THREAD_LIFESPAN_CHANGED;
        }

        @Override
        protected TraceEvent<TraceThread, Void> getChangedType() {
            return TraceEvents.THREAD_CHANGED;
        }

        @Override
        protected boolean appliesToKey(String key) {
            return this.keys.contains(key);
        }

        @Override
        protected TraceEvent<TraceThread, Void> getDeletedType() {
            return TraceEvents.THREAD_DELETED;
        }
    }
}

