/*
 * Decompiled with CFR 0.152.
 */
package sarif;

import docking.widgets.EventTrigger;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.plugin.core.graph.AddressBasedGraphDisplayListener;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.util.ProgramLocation;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sarif.SarifController;

public class SarifGraphDisplayListener
extends AddressBasedGraphDisplayListener {
    private Map<Address, Set<AttributedVertex>> map = new HashMap<Address, Set<AttributedVertex>>();
    private SarifController controller;
    private AttributedGraph graph;

    public SarifGraphDisplayListener(SarifController controller, GraphDisplay display, AttributedGraph graph) {
        super(controller.getPlugin().getTool(), controller.getProgram(), display);
        this.controller = controller;
        this.graph = graph;
        for (AttributedVertex vertex : graph.vertexSet()) {
            String addrStr = vertex.getAttribute("Address");
            if (addrStr == null) continue;
            Address address = this.program.getAddressFactory().getAddress(addrStr);
            Set<AttributedVertex> set = this.map.get(address);
            if (set == null) {
                set = new HashSet<AttributedVertex>();
            }
            set.add(vertex);
            this.map.put(address, set);
        }
    }

    public void eventSent(PluginEvent event) {
        ProgramLocation location;
        Set<AttributedVertex> vertices;
        ProgramLocationPluginEvent ev;
        super.eventSent(event);
        if (event instanceof ProgramLocationPluginEvent && this.program.equals((Object)(ev = (ProgramLocationPluginEvent)event).getProgram()) && (vertices = this.getVertices((location = ev.getLocation()).getAddress())) != null) {
            this.graphDisplay.selectVertices(vertices, EventTrigger.INTERNAL_ONLY);
        }
    }

    public void selectionChanged(Set<AttributedVertex> vertices) {
        super.selectionChanged(vertices);
        this.controller.setSelection(vertices);
    }

    public Address getAddress(AttributedVertex vertex) {
        String addrStr = vertex.getAttribute("Address");
        Address address = this.program.getAddressFactory().getAddress(addrStr);
        return address;
    }

    protected Set<AttributedVertex> getVertices(Address address) {
        return this.map.get(address);
    }

    protected Set<AttributedVertex> getVertices(AddressSetView addrSet) {
        if (addrSet.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<AttributedVertex> vertices = new HashSet<AttributedVertex>();
        for (Map.Entry<Address, Set<AttributedVertex>> entry : this.map.entrySet()) {
            if (!addrSet.contains(entry.getKey())) continue;
            for (AttributedVertex v : entry.getValue()) {
                vertices.add(v);
            }
        }
        return vertices;
    }

    protected AddressSet getAddresses(Set<AttributedVertex> vertices) {
        AddressSet addrSet = new AddressSet();
        Collection<Set<AttributedVertex>> values = this.map.values();
        for (Set<AttributedVertex> set : values) {
            for (AttributedVertex vertex : vertices) {
                if (!set.contains(vertex)) continue;
                String addrStr = vertex.getAttribute("Address");
                Address address = this.program.getAddressFactory().getAddress(addrStr);
                addrSet.add(address);
            }
        }
        return addrSet;
    }

    protected boolean isValidAddress(Address addr) {
        if (addr == null || this.program == null) {
            return false;
        }
        return this.program.getMemory().contains(addr) || addr.isExternalAddress();
    }

    public GraphDisplayListener cloneWith(GraphDisplay newGraphDisplay) {
        return new SarifGraphDisplayListener(this.controller, newGraphDisplay, this.graph);
    }
}

