/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.values;

import docking.widgets.values.ValuesMapParseException;
import java.util.Objects;
import javax.swing.JComponent;

public abstract class AbstractValue<T> {
    private final String name;
    private T value;
    private T originalValue;

    protected AbstractValue(String name, T defaultValue) {
        this.name = Objects.requireNonNull(name);
        this.value = defaultValue;
        this.originalValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void copyValue(AbstractValue<T> other) {
        this.setValue(other.getValue());
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public T setAsText(String valueString) {
        if (valueString == null) {
            throw new IllegalArgumentException("Value string can not be null!");
        }
        this.value = this.fromString(valueString);
        return this.value;
    }

    public String getAsText() {
        return this.value == null ? null : this.toString(this.value);
    }

    protected void reset() {
        this.value = this.originalValue;
    }

    protected String toString(T t) {
        return t.toString();
    }

    public abstract JComponent getComponent();

    protected abstract void updateValueFromComponent() throws ValuesMapParseException;

    protected abstract void updateComponentFromValue();

    protected abstract T fromString(String var1);
}

