/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.textfield;

import docking.widgets.textfield.HexDecimalModeTextField;
import ghidra.util.SystemUtilities;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class IntegerTextField {
    private HexDecimalModeTextField textField;
    private boolean isHexMode = false;
    private boolean allowsNegative = true;
    private boolean allowsHexPrefix = true;
    private BigInteger maxValue;
    private BigInteger minValue;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public IntegerTextField() {
        this(5, null);
    }

    public IntegerTextField(int columns) {
        this(columns, null);
    }

    public IntegerTextField(int columns, long initialValue) {
        this(columns, BigInteger.valueOf(initialValue));
    }

    public IntegerTextField(int columns, BigInteger initialValue) {
        this.textField = new HexDecimalModeTextField(columns, b -> this.textFieldHexModeChanged((boolean)b));
        AbstractDocument document = (AbstractDocument)this.textField.getDocument();
        document.setDocumentFilter(new HexDecimalDocumentFilter());
        this.setValue(initialValue);
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SystemUtilities.runSwingLater(() -> IntegerTextField.this.valueChanged());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SystemUtilities.runSwingLater(() -> IntegerTextField.this.valueChanged());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SystemUtilities.runSwingLater(() -> IntegerTextField.this.valueChanged());
            }
        });
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void setAccessibleName(String name) {
        this.textField.getAccessibleContext().setAccessibleName(name);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public BigInteger getValue() {
        String text = this.textField.getText();
        return this.computeValueFromString(text, this.isHexMode);
    }

    public int getIntValue() {
        BigInteger currentValue = this.getValue();
        if (currentValue == null) {
            return 0;
        }
        return currentValue.intValueExact();
    }

    public long getLongValue() {
        BigInteger currentValue = this.getValue();
        if (currentValue == null) {
            return 0L;
        }
        return currentValue.longValueExact();
    }

    public void setValue(long newValue) {
        this.setValue(BigInteger.valueOf(newValue));
    }

    public void setValue(int newValue) {
        this.setValue(BigInteger.valueOf(newValue));
    }

    public boolean setText(String text) {
        String oldText = this.textField.getText();
        this.textField.setText(text);
        return !oldText.equals(this.textField.getText());
    }

    public void setValue(BigInteger newValue) {
        if (!this.allowsNegative && newValue != null && newValue.signum() < 0) {
            newValue = null;
        }
        this.updateTextField(newValue);
    }

    public void setShowNumberMode(boolean show) {
        this.textField.setShowNumberMode(show);
    }

    public void setHexMode() {
        BigInteger value = this.getValue();
        this.setHexMode(true);
        this.setValue(value);
    }

    private void setHexMode(boolean hexMode) {
        this.isHexMode = hexMode;
        this.textField.setHexMode(hexMode);
    }

    public void setDecimalMode() {
        BigInteger value = this.getValue();
        this.setHexMode(false);
        this.setValue(value);
    }

    public void setAllowsHexPrefix(boolean allowsHexPrefix) {
        BigInteger currentValue = this.getValue();
        this.allowsHexPrefix = allowsHexPrefix;
        this.updateTextField(currentValue);
    }

    public String getText() {
        return this.textField.getText();
    }

    public boolean isHexMode() {
        return this.isHexMode;
    }

    public void setAllowNegativeValues(boolean b) {
        BigInteger currentValue = this.getValue();
        this.allowsNegative = b;
        if (!this.allowsNegative && currentValue != null && currentValue.signum() < 0) {
            currentValue = null;
        }
        this.updateTextField(currentValue);
    }

    public BigInteger getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(BigInteger maxValue) {
        if (maxValue != null && maxValue.signum() < 0) {
            throw new IllegalArgumentException("Max value must be positive");
        }
        BigInteger currentValue = this.getValue();
        this.maxValue = maxValue;
        if (maxValue != null && !this.passesMaxCheck(currentValue)) {
            if (currentValue.signum() < 0) {
                this.setValue(maxValue.negate());
            } else {
                this.setValue(maxValue);
            }
        }
    }

    public void setMinValue(BigInteger minValue) {
        if (minValue != null && minValue.signum() < 0) {
            throw new IllegalArgumentException("Min value must be positive");
        }
        BigInteger currentValue = this.getValue();
        this.minValue = minValue;
        if (minValue != null && !this.passesMinCheck(currentValue)) {
            if (currentValue.signum() < 0) {
                this.setValue(minValue.negate());
            } else {
                this.setValue(minValue);
            }
        }
    }

    public JComponent getComponent() {
        return this.textField;
    }

    public void addActionListener(ActionListener listener) {
        this.textField.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.textField.removeActionListener(listener);
    }

    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
    }

    public void setEditable(boolean editable) {
        this.textField.setEditable(editable);
    }

    public void requestFocus() {
        this.textField.requestFocus();
    }

    public void selectAll() {
        this.textField.selectAll();
    }

    public void setHorizontalAlignment(int alignment) {
        this.textField.setHorizontalAlignment(alignment);
    }

    private void textFieldHexModeChanged(boolean hexMode) {
        BigInteger value = this.getValue();
        this.isHexMode = hexMode;
        this.setValue(value);
    }

    private String computeTextForValue(BigInteger value) {
        if (value == null) {
            return "";
        }
        if (this.isHexMode) {
            String text = value.toString(16);
            if (this.allowsHexPrefix) {
                if (text.startsWith("-")) {
                    return "-0x" + text.substring(1);
                }
                return "0x" + text;
            }
            return text;
        }
        return value.toString(10);
    }

    private BigInteger computeValueFromString(String text, boolean parseAsHex) {
        if (((String)text).isEmpty() || this.isValidPrefix((String)text)) {
            return null;
        }
        if (!parseAsHex) {
            return new BigInteger((String)text, 10);
        }
        if (this.allowsHexPrefix) {
            if (((String)text).startsWith("0x")) {
                text = ((String)text).substring(2);
            } else if (((String)text).startsWith("-0x")) {
                text = "-" + ((String)text).substring(3);
            }
        }
        if (((String)text).isEmpty()) {
            return null;
        }
        return new BigInteger((String)text, 16);
    }

    private void valueChanged() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    private boolean passesMaxCheck(BigInteger value) {
        if (value == null) {
            return true;
        }
        if (this.maxValue == null) {
            return true;
        }
        return value.abs().compareTo(this.maxValue) <= 0;
    }

    private boolean passesMinCheck(BigInteger value) {
        if (value == null) {
            return true;
        }
        if (this.minValue == null) {
            return true;
        }
        return value.abs().compareTo(this.minValue) >= 0;
    }

    private boolean shouldParseAsHex(String text) {
        if (this.allowsHexPrefix) {
            return text.startsWith("0x") || text.startsWith("-0x");
        }
        return this.isHexMode;
    }

    private void updateTextField(BigInteger value) {
        String text = this.computeTextForValue(value);
        this.textField.setText(text);
    }

    private boolean isValidPrefix(String s) {
        switch (s) {
            case "0x": {
                return this.allowsHexPrefix;
            }
            case "-0x": {
                return this.allowsHexPrefix && this.allowsNegative;
            }
            case "-": {
                return this.allowsNegative;
            }
        }
        return false;
    }

    private boolean isNonAllowedNegativeNumber(BigInteger value) {
        if (value == null) {
            return false;
        }
        if (this.allowsNegative) {
            return false;
        }
        return value.signum() < 0;
    }

    private class HexDecimalDocumentFilter
    extends DocumentFilter {
        private HexDecimalDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
            text = text.replace('X', 'x');
            StringBuilder builder = this.getText(fb);
            builder.insert(offset, text);
            if (this.isValid(builder)) {
                super.insertString(fb, offset, text, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            text = text.replace('X', 'x');
            StringBuilder builder = this.getText(fb);
            builder.replace(offset, offset + length, text);
            if (this.isValid(builder)) {
                super.replace(fb, offset, length, text, attrs);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            StringBuilder builder = this.getText(fb);
            builder.delete(offset, offset + length);
            if (this.isValid(builder)) {
                super.remove(fb, offset, length);
            }
        }

        private boolean isValid(StringBuilder builder) {
            String valueString = builder.toString();
            boolean parseAsHex = IntegerTextField.this.shouldParseAsHex(valueString);
            if (IntegerTextField.this.isValidPrefix(valueString)) {
                IntegerTextField.this.setHexMode(parseAsHex);
                return true;
            }
            try {
                BigInteger value = IntegerTextField.this.computeValueFromString(valueString, parseAsHex);
                if (IntegerTextField.this.isNonAllowedNegativeNumber(value)) {
                    return false;
                }
                if (IntegerTextField.this.passesMaxCheck(value) && IntegerTextField.this.passesMinCheck(value)) {
                    IntegerTextField.this.setHexMode(parseAsHex);
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            return false;
        }

        private StringBuilder getText(DocumentFilter.FilterBypass fb) throws BadLocationException {
            StringBuilder builder = new StringBuilder();
            Document document = fb.getDocument();
            builder.append(document.getText(0, document.getLength()));
            return builder;
        }
    }
}

