/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ActionContext;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import ghidra.util.Swing;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.KeyStroke;

public class ShowContextMenuAction
extends DockingAction {
    public ShowContextMenuAction(KeyStroke keyStroke, boolean isPrimary) {
        super(isPrimary ? "Show Context Menu" : "Show Context Menu Alternate", "DockingWindows", isPrimary);
        if (isPrimary) {
            this.setKeyBindingData(new KeyBindingData(keyStroke));
        } else {
            this.createSystemKeyBinding(keyStroke);
        }
    }

    @Override
    public void actionPerformed(ActionContext context) {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window window = kfm.getActiveWindow();
        if (window == null) {
            return;
        }
        Component focusOwner = kfm.getFocusOwner();
        if (focusOwner != null) {
            Swing.runLater(() -> DockingWindowManager.showContextMenu(focusOwner));
        }
    }
}

