/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.taint.trace;

import ghidra.pcode.emu.taint.plain.TaintSpace;
import ghidra.pcode.exec.trace.data.PcodeTracePropertyAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.taint.model.TaintSet;
import java.util.Map;

public class TaintTraceSpace
extends TaintSpace {
    protected final AddressSpace space;
    protected final PcodeTracePropertyAccess<String> property;

    public TaintTraceSpace(AddressSpace space, PcodeTracePropertyAccess<String> property) {
        this.space = space;
        this.property = property;
    }

    @Override
    protected TaintSet whenNull(long offset) {
        String string = (String)this.property.get(this.space.getAddress(offset));
        if (string == null) {
            return TaintSet.EMPTY;
        }
        return TaintSet.parse(string);
    }

    public void writeDown(PcodeTracePropertyAccess<String> into) {
        if (this.space.isUniqueSpace()) {
            return;
        }
        for (Map.Entry entry : this.taints.entrySet()) {
            TaintSet taint = (TaintSet)entry.getValue();
            Address address = this.space.getAddress(((Long)entry.getKey()).longValue());
            if (taint.isEmpty()) {
                into.clear((AddressRange)new AddressRangeImpl(address, address));
                continue;
            }
            into.put(address, (Object)taint.toString());
        }
    }
}

