/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.util.ErrorHandler;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreEntrySubSet;
import ghidra.util.database.DBCachedObjectStoreKeySubSet;
import ghidra.util.database.DBCachedObjectStoreMap;
import ghidra.util.database.DBCachedObjectStoreValueSubCollection;
import ghidra.util.database.DirectedIterator;
import ghidra.util.database.KeySpan;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;

public class DBCachedObjectStoreSubMap<T extends DBAnnotatedObject>
extends DBCachedObjectStoreMap<T> {
    protected final KeySpan keySpan;

    public DBCachedObjectStoreSubMap(DBCachedObjectStore<T> store, ErrorHandler errHandler, ReadWriteLock lock, DirectedIterator.Direction direction, KeySpan keySpan) {
        super(store, errHandler, lock, direction);
        this.keySpan = keySpan;
    }

    @Override
    public int size() {
        return this.store.getKeyCount(this.keySpan);
    }

    @Override
    public boolean isEmpty() {
        return !this.store.getKeysExist(this.keySpan);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.contains(key, this.keySpan));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.store.safe(this.lock.readLock(), () -> this.store.objects.contains(value, this.keySpan));
    }

    @Override
    public T get(Object key) {
        if (!(key instanceof Long)) {
            return null;
        }
        long kl = (Long)key;
        if (!this.keySpan.contains(kl)) {
            return null;
        }
        return this.store.getObjectAt(kl);
    }

    @Override
    public T remove(Object key) {
        if (!(key instanceof Long)) {
            return null;
        }
        long kl = (Long)key;
        if (!this.keySpan.contains(kl)) {
            return null;
        }
        return this.store.deleteKey(kl);
    }

    @Override
    public void clear() {
        this.store.deleteKeys(this.keySpan);
    }

    @Override
    public Map.Entry<Long, T> firstEntry() {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.first(this.direction, this.keySpan));
    }

    @Override
    public Long firstKey() {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.first(this.direction, this.keySpan));
    }

    @Override
    public Map.Entry<Long, T> lastEntry() {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.last(this.direction, this.keySpan));
    }

    @Override
    public Long lastKey() {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.last(this.direction, this.keySpan));
    }

    @Override
    public Map.Entry<Long, T> lowerEntry(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.lower(this.direction, key, this.keySpan));
    }

    @Override
    public Long lowerKey(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.lower(this.direction, key, this.keySpan));
    }

    @Override
    public Map.Entry<Long, T> floorEntry(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.floor(this.direction, key, this.keySpan));
    }

    @Override
    public Long floorKey(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.floor(this.direction, key, this.keySpan));
    }

    @Override
    public Map.Entry<Long, T> ceilingEntry(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.ceiling(this.direction, key, this.keySpan));
    }

    @Override
    public Long ceilingKey(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.ceiling(this.direction, key, this.keySpan));
    }

    @Override
    public Map.Entry<Long, T> higherEntry(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.higher(this.direction, key, this.keySpan));
    }

    @Override
    public Long higherKey(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.higher(this.direction, key, this.keySpan));
    }

    @Override
    public Map.Entry<Long, T> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map.Entry<Long, T> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DBCachedObjectStoreKeySubSet keySet() {
        return this.navigableKeySet();
    }

    @Override
    public DBCachedObjectStoreValueSubCollection<T> values() {
        return new DBCachedObjectStoreValueSubCollection(this.store, this.errHandler, this.lock, this.direction, this.keySpan);
    }

    @Override
    public DBCachedObjectStoreEntrySubSet<T> entrySet() {
        return new DBCachedObjectStoreEntrySubSet(this.store, this.errHandler, this.lock, this.direction, this.keySpan);
    }

    @Override
    public DBCachedObjectStoreSubMap<T> descendingMap() {
        return new DBCachedObjectStoreSubMap<T>(this.store, this.errHandler, this.lock, DirectedIterator.Direction.reverse(this.direction), this.keySpan);
    }

    @Override
    public DBCachedObjectStoreKeySubSet navigableKeySet() {
        return new DBCachedObjectStoreKeySubSet(this.store, this.errHandler, this.lock, this.direction, this.keySpan);
    }

    @Override
    public DBCachedObjectStoreKeySubSet descendingKeySet() {
        return new DBCachedObjectStoreKeySubSet(this.store, this.errHandler, this.lock, DirectedIterator.Direction.reverse(this.direction), this.keySpan);
    }

    @Override
    public DBCachedObjectStoreSubMap<T> subMap(Long fromKey, boolean fromInclusive, Long toKey, boolean toInclusive) {
        KeySpan span = KeySpan.sub(fromKey, fromInclusive, toKey, toInclusive, this.direction);
        return new DBCachedObjectStoreSubMap<T>(this.store, this.errHandler, this.lock, this.direction, (KeySpan)this.keySpan.intersect(span));
    }

    @Override
    public DBCachedObjectStoreSubMap<T> headMap(Long toKey, boolean inclusive) {
        KeySpan span = KeySpan.head(toKey, inclusive, this.direction);
        return new DBCachedObjectStoreSubMap<T>(this.store, this.errHandler, this.lock, this.direction, (KeySpan)this.keySpan.intersect(span));
    }

    @Override
    public DBCachedObjectStoreSubMap<T> tailMap(Long fromKey, boolean inclusive) {
        KeySpan span = KeySpan.tail(fromKey, inclusive, this.direction);
        return new DBCachedObjectStoreSubMap<T>(this.store, this.errHandler, this.lock, this.direction, (KeySpan)this.keySpan.intersect(span));
    }
}

