/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.EnumeratedColumnTableModel;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.TableSortingContext;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.table.column.GColumnRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;

public class DefaultEnumeratedColumnTableModel<C extends Enum<C>, R>
extends GDynamicColumnTableModel<R, Void>
implements EnumeratedColumnTableModel<R> {
    private final List<R> modelData = new ArrayList<R>();
    private final String name;
    private final C[] cols;

    public DefaultEnumeratedColumnTableModel(PluginTool tool, String name, Class<C> colType) {
        super((ServiceProvider)tool);
        this.name = name;
        this.cols = (Enum[])colType.getEnumConstants();
        this.reloadColumns();
    }

    public String getName() {
        return this.name;
    }

    public List<R> getModelData() {
        return this.modelData;
    }

    protected TableColumnDescriptor<R> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        if (this.cols != null) {
            List<C> defaultOrder = this.defaultSortOrder();
            for (C col : this.cols) {
                EnumeratedDynamicTableColumn ecol = new EnumeratedDynamicTableColumn((EnumeratedTableColumn)col);
                if (((EnumeratedTableColumn)col).isVisible()) {
                    descriptor.addVisibleColumn(ecol, defaultOrder.indexOf(col), ((EnumeratedTableColumn)col).defaultSortDirection().isAscending());
                    continue;
                }
                descriptor.addHiddenColumn(ecol);
            }
        }
        return descriptor;
    }

    public Void getDataSource() {
        return null;
    }

    public List<C> defaultSortOrder() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        DynamicTableColumn column = (DynamicTableColumn)this.tableColumns.get(columnIndex);
        if (!(column instanceof EnumeratedColumnTableModel.EditableDynamicTableColumn)) {
            return;
        }
        EnumeratedColumnTableModel.EditableDynamicTableColumn editable = (EnumeratedColumnTableModel.EditableDynamicTableColumn)column;
        List<R> list = this.modelData;
        synchronized (list) {
            if (rowIndex < 0 || rowIndex >= this.modelData.size()) {
                return;
            }
            R row = this.modelData.get(rowIndex);
            editable.setValueOf(row, aValue, (Settings)this.columnSettings.get(column), this.getDataSource(), this.serviceProvider);
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        DynamicTableColumn column = (DynamicTableColumn)this.tableColumns.get(columnIndex);
        if (!(column instanceof EnumeratedColumnTableModel.EditableDynamicTableColumn)) {
            return false;
        }
        EnumeratedColumnTableModel.EditableDynamicTableColumn editable = (EnumeratedColumnTableModel.EditableDynamicTableColumn)column;
        List<R> list = this.modelData;
        synchronized (list) {
            if (rowIndex < 0 || rowIndex >= this.modelData.size()) {
                return false;
            }
            R row = this.modelData.get(rowIndex);
            return editable.isEditable(row, (Settings)this.columnSettings.get(column), this.getDataSource(), this.serviceProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(R row) {
        int rowIndex;
        List<R> list = this.modelData;
        synchronized (list) {
            rowIndex = this.modelData.size();
            this.modelData.add(row);
        }
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAll(Collection<R> c) {
        int endIndex;
        int startIndex;
        List<R> list = this.modelData;
        synchronized (list) {
            startIndex = this.modelData.size();
            this.modelData.addAll(c);
            endIndex = this.modelData.size() - 1;
        }
        this.fireTableRowsInserted(startIndex, endIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyUpdated(R row) {
        int rowIndex;
        List<R> list = this.modelData;
        synchronized (list) {
            rowIndex = this.modelData.indexOf(row);
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<R> notifyUpdatedWith(Predicate<R> predicate) {
        int lastIndexUpdated = 0;
        ArrayList<R> updated = new ArrayList<R>();
        ListIterator<R> rit = this.modelData.listIterator();
        List<R> list = this.modelData;
        synchronized (list) {
            while (rit.hasNext()) {
                R row = rit.next();
                if (!predicate.test(row)) continue;
                lastIndexUpdated = rit.previousIndex();
                updated.add(row);
            }
        }
        int size = updated.size();
        if (size != 0) {
            if (size == 1) {
                this.fireTableRowsUpdated(lastIndexUpdated, lastIndexUpdated);
            } else {
                this.fireTableDataChanged();
            }
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(R row) {
        int rowIndex;
        List<R> list = this.modelData;
        synchronized (list) {
            rowIndex = this.modelData.indexOf(row);
            if (rowIndex == -1) {
                return;
            }
            this.modelData.remove(rowIndex);
        }
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<R> deleteWith(Predicate<R> predicate) {
        int lastIndexRemoved = 0;
        ArrayList<R> removed = new ArrayList<R>();
        List<R> list = this.modelData;
        synchronized (list) {
            ListIterator<R> rit = this.modelData.listIterator();
            while (rit.hasNext()) {
                R row = rit.next();
                if (!predicate.test(row)) continue;
                lastIndexRemoved = rit.previousIndex();
                rit.remove();
                removed.add(row);
            }
        }
        int size = removed.size();
        if (size != 0) {
            if (size == 1) {
                this.fireTableRowsDeleted(lastIndexRemoved, lastIndexRemoved);
            } else {
                this.fireTableDataChanged();
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R findFirst(Predicate<R> predicate) {
        List<R> list = this.modelData;
        synchronized (list) {
            for (R row : this.modelData) {
                if (!predicate.test(row)) continue;
                return row;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List<R> list = this.modelData;
        synchronized (list) {
            this.modelData.clear();
        }
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sort(List<R> data, TableSortingContext<R> sortingContext) {
        List<R> list = data;
        synchronized (list) {
            super.sort(data, sortingContext);
        }
    }

    static class EnumeratedDynamicTableColumn<R>
    extends AbstractDynamicTableColumn<R, Object, Void>
    implements EnumeratedColumnTableModel.EditableDynamicTableColumn<R, Object, Void> {
        private final EnumeratedTableColumn<?, R> col;

        public EnumeratedDynamicTableColumn(EnumeratedTableColumn<?, R> col) {
            this.col = col;
        }

        public String getColumnName() {
            return this.col.getHeader();
        }

        public Object getValue(R rowObject, Settings settings, Void data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return this.col.getValueOf(rowObject);
        }

        public Class<Object> getColumnClass() {
            return this.col.getValueClass();
        }

        @Override
        public boolean isEditable(R row, Settings settings, Void dataSource, ServiceProvider serviceProvider) {
            return this.col.isEditable(row);
        }

        @Override
        public void setValueOf(R row, Object value, Settings settings, Void dataSource, ServiceProvider serviceProvider) {
            this.col.setValueOf(row, value);
        }

        public GColumnRenderer<Object> getColumnRenderer() {
            return this.col.getRenderer();
        }

        public int getColumnPreferredWidth() {
            return this.col.getPreferredWidth();
        }

        public SettingsDefinition[] getSettingsDefinitions() {
            SettingsDefinition[] defs = this.col.getSettingsDefinitions();
            if (defs != null) {
                return defs;
            }
            return super.getSettingsDefinitions();
        }
    }

    public static interface EnumeratedTableColumn<C extends Enum<C>, R> {
        public Class<?> getValueClass();

        public Object getValueOf(R var1);

        public String getHeader();

        default public void setValueOf(R row, Object value) {
            throw new UnsupportedOperationException("Cell is not editable");
        }

        default public boolean isEditable(R row) {
            return false;
        }

        default public boolean isSortable() {
            return true;
        }

        default public boolean isVisible() {
            return true;
        }

        default public ColumnSortState.SortDirection defaultSortDirection() {
            return ColumnSortState.SortDirection.ASCENDING;
        }

        default public int getPreferredWidth() {
            return -1;
        }

        default public GColumnRenderer<?> getRenderer() {
            return null;
        }

        default public SettingsDefinition[] getSettingsDefinitions() {
            return null;
        }
    }
}

