/*
 * Decompiled with CFR 0.152.
 */
package generic.expressions;

import generic.expressions.ExpressionException;
import generic.expressions.ExpressionOperator;
import generic.expressions.ExpressionValue;

public class LongExpressionValue
implements ExpressionValue {
    private final long value;

    public LongExpressionValue(long value) {
        this.value = value;
    }

    public long getLongValue() {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public ExpressionValue applyUnaryOperator(ExpressionOperator operator) throws ExpressionException {
        switch (operator) {
            case BITWISE_NOT: {
                return new LongExpressionValue(this.value ^ 0xFFFFFFFFFFFFFFFFL);
            }
            case LOGICAL_NOT: {
                return new LongExpressionValue(this.value == 0L ? 1L : 0L);
            }
            case UNARY_MINUS: {
                return new LongExpressionValue(-this.value);
            }
            case UNARY_PLUS: {
                return this;
            }
        }
        throw new ExpressionException("Unary Operator " + String.valueOf(operator) + " not supported by Long values!");
    }

    @Override
    public ExpressionValue applyBinaryOperator(ExpressionOperator operator, ExpressionValue operand) throws ExpressionException {
        if (!(operand instanceof LongExpressionValue)) {
            throw new ExpressionException("Unsupported operand type for Long: " + this.value);
        }
        LongExpressionValue longOperand = (LongExpressionValue)operand;
        long otherValue = longOperand.value;
        switch (operator) {
            case BITWISE_AND: {
                return new LongExpressionValue(this.value & otherValue);
            }
            case BITWISE_OR: {
                return new LongExpressionValue(this.value | otherValue);
            }
            case BITWISE_XOR: {
                return new LongExpressionValue(this.value ^ otherValue);
            }
            case DIVIDE: {
                return new LongExpressionValue(this.value / otherValue);
            }
            case EQUALS: {
                return new LongExpressionValue(this.value == otherValue ? 1L : 0L);
            }
            case GREATER_THAN: {
                return new LongExpressionValue(this.value > otherValue ? 1L : 0L);
            }
            case GREATER_THAN_OR_EQUAL: {
                return new LongExpressionValue(this.value >= otherValue ? 1L : 0L);
            }
            case SHIFT_LEFT: {
                return new LongExpressionValue(this.value << (int)otherValue);
            }
            case LESS_THAN: {
                return new LongExpressionValue(this.value < otherValue ? 1L : 0L);
            }
            case LESS_THAN_OR_EQUAL: {
                return new LongExpressionValue(this.value <= otherValue ? 1L : 0L);
            }
            case LOGICAL_AND: {
                int b1 = this.value == 0L ? 0 : 1;
                int b2 = otherValue == 0L ? 0 : 1;
                return new LongExpressionValue(b1 & b2);
            }
            case LOGICAL_OR: {
                int b1 = this.value == 0L ? 0 : 1;
                int b2 = otherValue == 0L ? 0 : 1;
                return new LongExpressionValue(b1 | b2);
            }
            case SUBTRACT: {
                return new LongExpressionValue(this.value - otherValue);
            }
            case NOT_EQUALS: {
                return new LongExpressionValue(this.value == otherValue ? 0L : 1L);
            }
            case ADD: {
                return new LongExpressionValue(this.value + otherValue);
            }
            case SHIFT_RIGHT: {
                return new LongExpressionValue(this.value >> (int)otherValue);
            }
            case MULTIPLY: {
                return new LongExpressionValue(this.value * otherValue);
            }
        }
        throw new ExpressionException("Binary Operator \"" + String.valueOf(operator) + "\" not supported by Long values!");
    }
}

