/*
 * Decompiled with CFR 0.152.
 */
package generic.expressions;

import generic.expressions.ExpressionElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.map.LazyMap;

public enum ExpressionOperator implements ExpressionElement
{
    BITWISE_NOT("~", OpType.UNARY, 1),
    LOGICAL_NOT("!", OpType.UNARY, 1),
    UNARY_PLUS("+", OpType.UNARY, 1),
    UNARY_MINUS("-", OpType.UNARY, 1),
    MULTIPLY("*", OpType.BINARY, 2),
    DIVIDE("/", OpType.BINARY, 2),
    ADD("+", OpType.BINARY, 3),
    SUBTRACT("-", OpType.BINARY, 3),
    SHIFT_LEFT("<<", OpType.BINARY, 4),
    SHIFT_RIGHT(">>", OpType.BINARY, 4),
    LESS_THAN("<", OpType.BINARY, 5),
    GREATER_THAN(">", OpType.BINARY, 5),
    LESS_THAN_OR_EQUAL("<=", OpType.BINARY, 5),
    GREATER_THAN_OR_EQUAL(">=", OpType.BINARY, 5),
    EQUALS("==", OpType.BINARY, 6),
    NOT_EQUALS("!=", OpType.BINARY, 6),
    BITWISE_AND("&", OpType.BINARY, 7),
    BITWISE_XOR("^", OpType.BINARY, 8),
    BITWISE_OR("|", OpType.BINARY, 9),
    LOGICAL_AND("&&", OpType.BINARY, 10),
    LOGICAL_OR("||", OpType.BINARY, 11);

    public static List<Set<ExpressionOperator>> binaryOperatorsByPrecedence;
    private String name;
    private OpType type;
    private int precedence;

    private ExpressionOperator(String name, OpType type, int precedence) {
        this.name = name;
        this.type = type;
        this.precedence = precedence;
    }

    public String toString() {
        return this.name;
    }

    public static List<Set<ExpressionOperator>> getBinaryOperatorsByPrecedence() {
        if (binaryOperatorsByPrecedence == null) {
            binaryOperatorsByPrecedence = ExpressionOperator.buildOperatorsByPrecedenceList();
        }
        return binaryOperatorsByPrecedence;
    }

    private static List<Set<ExpressionOperator>> buildOperatorsByPrecedenceList() {
        ExpressionOperator[] values = ExpressionOperator.values();
        LazyMap map = LazyMap.lazyMap(new TreeMap(), k -> new HashSet());
        for (ExpressionOperator op : values) {
            if (!op.isBinary()) continue;
            ((HashSet)map.get((Object)op.precedence)).add(op);
        }
        return new ArrayList<Set<ExpressionOperator>>(map.values());
    }

    public static ExpressionOperator getOperator(String token, String lookahead1, boolean preferBinary) {
        String doubleToken;
        ExpressionOperator operator;
        if (lookahead1 != null && (operator = ExpressionOperator.findOperator(doubleToken = token + lookahead1, preferBinary)) != null) {
            return operator;
        }
        return ExpressionOperator.findOperator(token, preferBinary);
    }

    private static ExpressionOperator findOperator(String tokens, boolean expectBinary) {
        for (ExpressionOperator operator : ExpressionOperator.values()) {
            if (!operator.name.equals(tokens) || operator.isBinary() != expectBinary) continue;
            return operator;
        }
        return null;
    }

    public int size() {
        return this.name.length();
    }

    public boolean isUnary() {
        return this.type == OpType.UNARY;
    }

    public boolean isBinary() {
        return this.type == OpType.BINARY;
    }

    private static enum OpType {
        UNARY,
        BINARY;

    }
}

