/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.ByteField;
import db.DBHandle;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.LabelHistoryAdapterNoTable;
import ghidra.program.database.symbol.LabelHistoryAdapterV0;
import ghidra.program.model.address.Address;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Set;

abstract class LabelHistoryAdapter {
    static final String LABEL_HISTORY_TABLE_NAME = "Label History";
    static final Schema LABEL_HISTORY_SCHEMA = new Schema(0, "Key", new Field[]{LongField.INSTANCE, ByteField.INSTANCE, StringField.INSTANCE, StringField.INSTANCE, LongField.INSTANCE}, new String[]{"Address", "Action", "Labels", "User", "Date"});
    static final int HISTORY_ADDR_COL = 0;
    static final int HISTORY_ACTION_COL = 1;
    static final int HISTORY_LABEL_COL = 2;
    static final int HISTORY_USER_COL = 3;
    static final int HISTORY_DATE_COL = 4;

    LabelHistoryAdapter() {
    }

    static LabelHistoryAdapter getAdapter(DBHandle dbHandle, OpenMode openMode, AddressMap addrMap, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (openMode == OpenMode.CREATE) {
            return new LabelHistoryAdapterV0(dbHandle, true);
        }
        try {
            LabelHistoryAdapterV0 adapter = new LabelHistoryAdapterV0(dbHandle, false);
            if (addrMap.isUpgraded()) {
                throw new VersionException(true);
            }
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == OpenMode.UPDATE) {
                throw e;
            }
            LabelHistoryAdapter adapter = LabelHistoryAdapter.findReadOnlyAdapter(dbHandle);
            if (openMode == OpenMode.UPGRADE) {
                adapter = LabelHistoryAdapterV0.upgrade(dbHandle, addrMap, adapter, monitor);
            }
            return adapter;
        }
    }

    private static LabelHistoryAdapter findReadOnlyAdapter(DBHandle handle) throws IOException {
        try {
            return new LabelHistoryAdapterV0(handle, false);
        }
        catch (VersionException versionException) {
            return new LabelHistoryAdapterNoTable(handle);
        }
    }

    abstract void createRecord(long var1, byte var3, String var4) throws IOException;

    abstract RecordIterator getRecordsByAddress(long var1) throws IOException;

    abstract RecordIterator getAllRecords() throws IOException;

    abstract int getRecordCount();

    abstract void moveAddress(long var1, long var3) throws IOException;

    abstract void moveAddressRange(Address var1, Address var2, long var3, AddressMap var5, TaskMonitor var6) throws CancelledException, IOException;

    abstract void deleteAddressRange(Address var1, Address var2, AddressMap var3, Set<Address> var4, TaskMonitor var5) throws CancelledException, IOException;
}

