/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import db.DBHandle;
import db.DBLongIterator;
import db.DBRecord;
import db.Table;
import db.util.ErrorHandler;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressKeyAddressIterator;
import ghidra.program.database.map.AddressKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.references.BigRefListV0;
import ghidra.program.database.references.RecordAdapter;
import ghidra.program.database.references.RefList;
import ghidra.program.database.references.RefListV0;
import ghidra.program.database.references.ToAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OldGenericNamespaceAddress;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class ToAdapterV1
extends ToAdapter {
    private Table table;
    private AddressMap addrMap;
    private ErrorHandler errHandler;

    ToAdapterV1(DBHandle handle, boolean create, AddressMap addrMap, ErrorHandler errHandler) throws IOException, VersionException {
        this.addrMap = addrMap;
        this.errHandler = errHandler;
        if (create) {
            this.table = handle.createTable("TO REFS", TO_REFS_SCHEMA);
        } else {
            this.table = handle.getTable("TO REFS");
            if (this.table == null) {
                throw new VersionException("Missing Table: TO REFS");
            }
            if (this.table.getSchema().getVersion() != 1) {
                int version = this.table.getSchema().getVersion();
                if (version < 1) {
                    throw new VersionException(true);
                }
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    public RefList createRefList(ProgramDB program, DBObjectCache<RefList> cache, Address to) throws IOException {
        return new RefListV0(to, (RecordAdapter)this, this.addrMap, program, cache, false);
    }

    @Override
    public RefList getRefList(ProgramDB program, DBObjectCache<RefList> cache, Address to, long toAddr) throws IOException {
        DBRecord rec = this.table.getRecord(toAddr);
        if (rec != null) {
            if (rec.getBinaryData(1) == null) {
                return new BigRefListV0(rec, (RecordAdapter)this, this.addrMap, program, cache, false);
            }
            return new RefListV0(rec, (RecordAdapter)this, this.addrMap, program, cache, false);
        }
        return null;
    }

    @Override
    boolean hasRefTo(long toAddr) throws IOException {
        return this.table.hasRecord(toAddr);
    }

    @Override
    public DBRecord createRecord(long key, int numRefs, byte refLevel, byte[] refData) throws IOException {
        DBRecord rec = TO_REFS_SCHEMA.createRecord(key);
        rec.setIntValue(0, numRefs);
        rec.setBinaryData(1, refData);
        rec.setByteValue(2, refLevel);
        this.table.putRecord(rec);
        return rec;
    }

    @Override
    public DBRecord getRecord(long key) throws IOException {
        return this.table.getRecord(key);
    }

    @Override
    public void putRecord(DBRecord record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    public void removeRecord(long key) throws IOException {
        this.table.deleteRecord(key);
    }

    @Override
    AddressIterator getToIterator(boolean forward) throws IOException {
        return new AddressKeyAddressIterator(new AddressKeyIterator(this.table, this.addrMap, forward), forward, this.addrMap, this.errHandler);
    }

    @Override
    AddressIterator getToIterator(Address startAddr, boolean forward) throws IOException {
        return new AddressKeyAddressIterator(new AddressKeyIterator(this.table, this.addrMap, startAddr, forward), forward, this.addrMap, this.errHandler);
    }

    @Override
    AddressIterator getToIterator(AddressSetView set, boolean forward) throws IOException {
        return new AddressKeyAddressIterator(new AddressKeyIterator(this.table, this.addrMap, set, set.getMinAddress(), forward), forward, this.addrMap, this.errHandler);
    }

    @Override
    AddressIterator getOldNamespaceAddresses(AddressSpace addrSpace) throws IOException {
        long minKey = this.addrMap.getKey(OldGenericNamespaceAddress.getMinAddress(addrSpace, 1L), false);
        long maxKey = this.addrMap.getKey(OldGenericNamespaceAddress.getMaxAddress(addrSpace, 0xFFFFFFFL), false);
        return new MyAddressKeyAddressIterator(this.table.longKeyIterator(minKey, maxKey, minKey));
    }

    @Override
    int getRecordCount() {
        return this.table.getRecordCount();
    }

    private class MyAddressKeyAddressIterator
    implements AddressIterator {
        private DBLongIterator keyIter;

        public MyAddressKeyAddressIterator(DBLongIterator keyIter) {
            this.keyIter = keyIter;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            try {
                return this.keyIter.hasNext();
            }
            catch (IOException e) {
                ToAdapterV1.this.errHandler.dbError(e);
                return false;
            }
        }

        @Override
        public Address next() {
            Address addr = null;
            try {
                addr = ToAdapterV1.this.addrMap.decodeAddress(this.keyIter.next());
            }
            catch (NoSuchElementException e) {
                return null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return addr;
        }

        @Override
        public Iterator<Address> iterator() {
            return this;
        }
    }
}

