/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.properties;

import db.DBHandle;
import db.DBRecord;
import db.ObjectStorageAdapterDB;
import db.RecordIterator;
import db.Schema;
import db.Table;
import db.util.ErrorHandler;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.properties.GenericSaveable;
import ghidra.program.database.properties.PropertyMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.util.ObjectPropertyMap;
import ghidra.program.util.ChangeManager;
import ghidra.util.Msg;
import ghidra.util.ObjectStorage;
import ghidra.util.Saveable;
import ghidra.util.classfinder.ClassTranslator;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.function.Function;

public class ObjectPropertyMapDB<T extends Saveable>
extends PropertyMapDB<T>
implements ObjectPropertyMap<T> {
    private Class<T> saveableObjectClass;
    private int saveableObjectVersion;
    private boolean supportsPrivate;
    private Function<Long, T> valueReader = addrKey -> {
        Table table = this.propertyTable;
        DBRecord rec = null;
        try {
            if (table != null) {
                rec = table.getRecord(addrKey.longValue());
            }
            if (rec == null) {
                return null;
            }
            ObjectStorageAdapterDB objStorage = new ObjectStorageAdapterDB(rec);
            if (this.saveableObjectClass == GenericSaveable.class) {
                return new GenericSaveable(rec, this.propertyTable.getSchema());
            }
            Saveable obj = (Saveable)this.saveableObjectClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            obj.restore((ObjectStorage)objStorage);
            return obj;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InstantiationException e) {
            this.errHandler.dbError(new IOException("Could not instantiate " + e.getMessage()));
        }
        catch (Exception e) {
            this.errHandler.dbError(new IOException(e.getMessage()));
        }
        return null;
    };

    public ObjectPropertyMapDB(DBHandle dbHandle, OpenMode openMode, ErrorHandler errHandler, ChangeManager changeMgr, AddressMap addrMap, String name, Class<T> saveableObjectClass, TaskMonitor monitor, boolean supportsPrivate) throws VersionException, CancelledException, IOException {
        super(dbHandle, errHandler, changeMgr, addrMap, name);
        this.saveableObjectClass = saveableObjectClass;
        this.supportsPrivate = supportsPrivate;
        GenericSaveable tokenInstance = null;
        try {
            tokenInstance = saveableObjectClass == GenericSaveable.class ? new GenericSaveable(null, null) : (Saveable)saveableObjectClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.saveableObjectVersion = tokenInstance.getSchemaVersion();
        this.checkMapVersion(openMode, tokenInstance, monitor);
    }

    public static Class<? extends Saveable> getSaveableClassForName(String classPath) {
        Class<?> c;
        block7: {
            c = null;
            try {
                c = Class.forName(classPath);
            }
            catch (ClassNotFoundException e) {
                String newClassPath = ClassTranslator.get((String)classPath);
                if (newClassPath == null) break block7;
                classPath = newClassPath;
                try {
                    c = Class.forName(newClassPath);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (c == null) {
            Msg.error(ObjectPropertyMapDB.class, (Object)("Object property class not found: " + classPath));
        } else if (!Saveable.class.isAssignableFrom(c)) {
            Msg.error(ObjectPropertyMapDB.class, (Object)("Object property class does not implement Saveable interface: " + classPath));
        }
        return c != null ? c : GenericSaveable.class;
    }

    private void checkMapVersion(OpenMode openMode, T tokenInstance, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (this.propertyTable == null) {
            return;
        }
        int schemaVersion = this.schema.getVersion();
        if (schemaVersion > this.saveableObjectVersion) {
            Msg.warn((Object)this, (Object)("Program properties utilize a newer version of: " + this.saveableObjectClass.getName() + "(" + schemaVersion + ", " + this.saveableObjectVersion + ")"));
            throw new VersionException(2, false);
        }
        if (this.addrMap.isUpgraded() || schemaVersion < this.saveableObjectVersion) {
            if (openMode != OpenMode.UPGRADE) {
                throw new VersionException(true);
            }
            if (!this.upgradeTable(tokenInstance, monitor)) {
                Msg.showError((Object)this, null, (String)"Properties Removed on Upgrade", (Object)("Warning! unable to upgrade properties for " + this.saveableObjectClass.getName() + "\nThese properties have been removed."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upgradeTable(T tokenInstance, TaskMonitor monitor) throws CancelledException, IOException {
        boolean allRecordsUpgraded = true;
        AddressMap oldAddressMap = this.addrMap.getOldAddressMap();
        monitor.initialize((long)(this.propertyTable.getRecordCount() * 2));
        int count = 0;
        if (!tokenInstance.isUpgradeable(this.schema.getVersion())) {
            this.dbHandle.deleteTable(this.getTableName());
            this.propertyTable = null;
            this.schema = null;
            return false;
        }
        try (DBHandle tmpDb = new DBHandle();){
            DBRecord rec2;
            tmpDb.startTransaction();
            Schema newSchema = null;
            Table tempTable = null;
            RecordIterator iter = this.propertyTable.iterator();
            while (iter.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                rec2 = iter.next();
                ObjectStorageAdapterDB oldObjStorage = new ObjectStorageAdapterDB(rec2);
                ObjectStorageAdapterDB newObjStorage = new ObjectStorageAdapterDB();
                if (!tokenInstance.upgrade((ObjectStorage)oldObjStorage, this.schema.getVersion(), (ObjectStorage)newObjStorage)) {
                    allRecordsUpgraded = false;
                    continue;
                }
                if (newSchema == null) {
                    newSchema = newObjStorage.getSchema(this.saveableObjectVersion);
                    tempTable = tmpDb.createTable(this.getTableName(), newSchema);
                }
                Address addr = oldAddressMap.decodeAddress(rec2.getKey());
                DBRecord newRecord = newSchema.createRecord(this.addrMap.getKey(addr, true));
                newObjStorage.save(newRecord);
                if (tempTable != null) {
                    tempTable.putRecord(newRecord);
                }
                monitor.setProgress((long)(++count));
            }
            this.dbHandle.deleteTable(this.getTableName());
            this.propertyTable = null;
            this.schema = null;
            if (tempTable == null) {
                boolean rec2 = false;
                return rec2;
            }
            this.propertyTable = this.dbHandle.createTable(this.getTableName(), newSchema);
            this.schema = newSchema;
            iter = tempTable.iterator();
            while (iter.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                rec2 = iter.next();
                this.propertyTable.putRecord(rec2);
                monitor.setProgress((long)(++count));
            }
        }
        return allRecordsUpgraded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Address addr, T value) {
        this.lock.acquire();
        try {
            DBRecord rec;
            this.checkDeleted();
            if (!this.saveableObjectClass.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("value is not " + this.saveableObjectClass.getName());
            }
            long addrKey = this.addrMap.getKey(addr, true);
            Saveable oldValue = null;
            if (this.propertyTable != null && (oldValue = (Saveable)this.cache.get(addrKey)) == null) {
                oldValue = (Saveable)this.valueReader.apply(addrKey);
            }
            String tableName = this.getTableName();
            if (this.saveableObjectClass != GenericSaveable.class) {
                ObjectStorageAdapterDB objStorage = new ObjectStorageAdapterDB();
                value.save((ObjectStorage)objStorage);
                Schema s = objStorage.getSchema(value.getSchemaVersion());
                this.checkSchema(s);
                this.createPropertyTable(tableName, s);
                rec = this.schema.createRecord(addrKey);
                objStorage.save(rec);
            } else {
                GenericSaveable genericSaveable = (GenericSaveable)value;
                DBRecord originalRec = genericSaveable.record;
                Schema s = genericSaveable.schema;
                this.checkSchema(s);
                this.createPropertyTable(tableName, s);
                rec = originalRec.copy();
                rec.setKey(addrKey);
            }
            this.propertyTable.putRecord(rec);
            this.cache.put(addrKey, value);
            if (!this.isPrivate((Saveable)value)) {
                this.changeMgr.setPropertyChanged(this.name, addr, oldValue, value);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    private boolean isPrivate(Saveable value) {
        if (!this.supportsPrivate) {
            return false;
        }
        return value.isPrivate();
    }

    private void createPropertyTable(String tableName, Schema s) throws IOException {
        if (this.propertyTable == null) {
            this.schema = s;
            this.propertyTable = this.dbHandle.createTable(tableName, this.schema);
        }
    }

    private void checkSchema(Schema s) {
        if (this.schema != null && !this.schema.equals((Object)s)) {
            throw new RuntimeException("incompatible property storage: class=" + this.saveableObjectClass.getName() + " tableName=" + this.getTableName());
        }
    }

    @Override
    public Class<T> getValueClass() {
        return this.saveableObjectClass;
    }

    @Override
    public T get(Address addr) {
        this.validate(this.lock);
        Table table = this.propertyTable;
        if (table == null) {
            return null;
        }
        long addrKey = this.addrMap.getKey(addr, false);
        if (addrKey == -1L) {
            return null;
        }
        return (T)((Saveable)this.cache.computeIfAbsent(addrKey, this.valueReader));
    }

    protected void createTable() {
        throw new AssertException();
    }
}

