/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.DBBuffer;
import db.DBHandle;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.database.mem.FileBytesAdapterNoTable;
import ghidra.program.database.mem.FileBytesAdapterV0;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

abstract class FileBytesAdapter {
    static final int MAX_BUF_SIZE = 1000000000;
    public static final int FILENAME_COL = 0;
    public static final int OFFSET_COL = 1;
    public static final int SIZE_COL = 2;
    public static final int BUF_IDS_COL = 3;
    public static final int LAYERED_BUF_IDS_COL = 4;
    protected DBHandle handle;
    private static int maxBufSize = 1000000000;
    protected MemoryMapDB memMap;

    FileBytesAdapter(DBHandle handle) {
        this.handle = handle;
    }

    static FileBytesAdapter getAdapter(DBHandle handle, OpenMode openMode, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == OpenMode.CREATE) {
            return new FileBytesAdapterV0(handle, true);
        }
        try {
            return new FileBytesAdapterV0(handle, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == OpenMode.UPDATE) {
                throw e;
            }
            FileBytesAdapter adapter = FileBytesAdapter.findReadOnlyAdapter(handle);
            if (openMode == OpenMode.UPGRADE) {
                adapter = FileBytesAdapter.upgrade(handle, adapter, monitor);
            }
            return adapter;
        }
    }

    private static FileBytesAdapter findReadOnlyAdapter(DBHandle handle) {
        return new FileBytesAdapterNoTable(handle);
    }

    private static FileBytesAdapter upgrade(DBHandle handle, FileBytesAdapter oldAdapter, TaskMonitor monitor) throws VersionException, IOException {
        return new FileBytesAdapterV0(handle, true);
    }

    abstract FileBytes createFileBytes(String var1, long var2, long var4, InputStream var6, TaskMonitor var7) throws IOException;

    DBBuffer getBuffer(int bufferID) throws IOException {
        if (bufferID >= 0) {
            return this.handle.getBuffer(bufferID);
        }
        return null;
    }

    DBBuffer getBuffer(int bufferID, DBBuffer shadowBuffer) throws IOException {
        if (bufferID >= 0) {
            return this.handle.getBuffer(bufferID, shadowBuffer);
        }
        return null;
    }

    static int getMaxBufferSize() {
        return maxBufSize;
    }

    static void setMaxBufferSize(int testSize) {
        maxBufSize = testSize;
    }

    abstract List<FileBytes> getAllFileBytes();

    abstract void refresh() throws IOException;

    abstract boolean deleteFileBytes(FileBytes var1) throws IOException;
}

