/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.gui.framework;

import com.jeta.open.gui.framework.JETAContainer;
import com.jeta.open.gui.framework.UIDirector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class JETAController {
    private JETAContainer m_view;
    private CommandListener m_cmdListener = new CommandListener();
    private ListenerManager m_action_listeners = new ListenerManager();
    private ListListener m_llistener = new ListListener();
    private ListenerManager m_list_listeners;
    private ComponentChangeListener m_clistener = new ComponentChangeListener();
    private ListenerManager m_change_listeners;
    private TextFocusListener m_text_focus_listener = new TextFocusListener();
    private HashMap m_txt_values = new HashMap();
    private boolean m_events_enabled = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JETAController(JETAContainer jETAContainer) {
        this.m_view = jETAContainer;
    }

    public boolean actionPerformed(String string, ActionEvent actionEvent) {
        if (this.isEventsEnabled()) {
            UIDirector uIDirector;
            JETAContainer jETAContainer;
            boolean bl = false;
            ActionListener actionListener = (ActionListener)this.m_action_listeners.getListener(string);
            if (actionListener != null) {
                actionListener.actionPerformed(actionEvent);
                bl = true;
            }
            if ((jETAContainer = this.getView()) != null && (uIDirector = jETAContainer.getUIDirector()) != null) {
                uIDirector.updateComponents(actionEvent);
            }
            return bl;
        }
        return false;
    }

    public void assignAction(String string, ActionListener actionListener) {
        this.assignAction(this.getView(), string, actionListener);
    }

    private void assignAction(JETAContainer jETAContainer, String string, ActionListener actionListener) {
        Collection collection = jETAContainer.getComponentsByName(string);
        if (collection.size() == 0) {
            System.out.println("JETAController.assignAction failed for: " + string);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (component == null) continue;
            this.assignComponentAction(component, string, actionListener);
        }
        this.m_action_listeners.assignListener(string, actionListener);
    }

    protected void assignComponentAction(Component component, String string, ActionListener actionListener) {
        block7: {
            try {
                Method method;
                if (component instanceof AbstractButton) {
                    AbstractButton abstractButton = (AbstractButton)component;
                    abstractButton.removeActionListener(this.m_cmdListener);
                    abstractButton.addActionListener(this.m_cmdListener);
                    abstractButton.setActionCommand(string);
                    break block7;
                }
                if (component instanceof JTextField) {
                    JTextField jTextField = (JTextField)component;
                    jTextField.removeActionListener(this.m_cmdListener);
                    jTextField.addActionListener(this.m_cmdListener);
                    jTextField.setActionCommand(string);
                    jTextField.addFocusListener(this.m_text_focus_listener);
                    break block7;
                }
                if (component instanceof JComboBox) {
                    JComboBox jComboBox = (JComboBox)component;
                    jComboBox.removeActionListener(this.m_cmdListener);
                    jComboBox.addActionListener(this.m_cmdListener);
                    jComboBox.setActionCommand(string);
                    break block7;
                }
                Class[] classArray = new Class[]{ActionListener.class};
                Object[] objectArray = new Object[]{this.m_cmdListener};
                try {
                    method = component.getClass().getMethod("removeActionListener", classArray);
                    method.invoke((Object)component, objectArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                method = component.getClass().getMethod("addActionListener", classArray);
                method.invoke((Object)component, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void assignListener(String string, ListSelectionListener listSelectionListener) {
        this.assignListener(this.getView(), string, listSelectionListener);
    }

    private void assignListener(JETAContainer jETAContainer, String string, ListSelectionListener listSelectionListener) {
        Component component = jETAContainer.getComponentByName(string);
        if (component instanceof JList) {
            JList jList = (JList)component;
            if (jList != null) {
                if (this.m_list_listeners == null) {
                    this.m_list_listeners = new ListenerManager();
                }
                jList.addListSelectionListener(this.m_llistener);
                this.m_list_listeners.assignListener(string, listSelectionListener);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    public void assignListener(String string, ChangeListener changeListener) {
        this.assignListener(this.getView(), string, changeListener);
    }

    private void assignListener(JETAContainer jETAContainer, String string, ChangeListener changeListener) {
        try {
            Component component = jETAContainer.getComponentByName(string);
            if (component != null) {
                if (this.m_change_listeners == null) {
                    this.m_change_listeners = new ListenerManager();
                }
                Class[] classArray = new Class[]{ChangeListener.class};
                Object[] objectArray = new Object[]{this.m_clistener};
                Method method = component.getClass().getMethod("addChangeListener", classArray);
                method.invoke((Object)component, objectArray);
                this.m_change_listeners.assignListener(string, changeListener);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void enableEvents(boolean bl) {
        this.m_events_enabled = bl;
    }

    public ActionListener getPrimaryActionListener() {
        return this.m_cmdListener;
    }

    public ActionListener getAction(String string) {
        return (ActionListener)this.m_action_listeners.getListener(string);
    }

    public JETAContainer getView() {
        return this.m_view;
    }

    public boolean invokeAction(String string) {
        return this.actionPerformed(string, new ActionEvent(this, 0, string));
    }

    public boolean isEventsEnabled() {
        return this.m_events_enabled;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.isEventsEnabled()) {
            UIDirector uIDirector;
            JETAContainer jETAContainer;
            if (this.m_change_listeners == null) {
                return;
            }
            Component component = (Component)changeEvent.getSource();
            ChangeListener changeListener = (ChangeListener)this.m_change_listeners.getListener(component.getName());
            if (changeListener != null) {
                changeListener.stateChanged(changeEvent);
            }
            if ((jETAContainer = this.getView()) != null && (uIDirector = jETAContainer.getUIDirector()) != null) {
                uIDirector.updateComponents(changeEvent);
            }
        }
    }

    public void updateComponents(Object object) {
        UIDirector uIDirector;
        JETAContainer jETAContainer;
        if (object == null) {
            object = this;
        }
        EventObject eventObject = null;
        if (!(object instanceof EventObject)) {
            eventObject = new EventObject(object);
        }
        if ((jETAContainer = this.getView()) != null && (uIDirector = jETAContainer.getUIDirector()) != null) {
            uIDirector.updateComponents(eventObject);
        }
    }

    private final String validate() {
        return null;
    }

    private final String validateInputs() {
        return this.validate();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.isEventsEnabled()) {
            UIDirector uIDirector;
            JETAContainer jETAContainer;
            if (this.m_list_listeners == null) {
                return;
            }
            JList jList = (JList)listSelectionEvent.getSource();
            ListSelectionListener listSelectionListener = (ListSelectionListener)this.m_list_listeners.getListener(jList.getName());
            if (listSelectionListener != null) {
                listSelectionListener.valueChanged(listSelectionEvent);
            }
            if ((jETAContainer = this.getView()) != null && (uIDirector = jETAContainer.getUIDirector()) != null) {
                uIDirector.updateComponents(listSelectionEvent);
            }
        }
    }

    private final boolean validateCustom() {
        return true;
    }

    static {
        $assertionsDisabled = !JETAController.class.desiredAssertionStatus();
    }

    public static class ListenerManager {
        private HashMap m_listeners = new HashMap();

        public Object getListener(String string) {
            return this.m_listeners.get(string);
        }

        public void assignListener(String string, Object object) {
            this.m_listeners.put(string, object);
        }
    }

    public class TextFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            JTextField jTextField = (JTextField)focusEvent.getSource();
            JETAController.this.m_txt_values.put(jTextField, jTextField.getText());
        }

        public void focusLost(FocusEvent focusEvent) {
            JTextField jTextField = (JTextField)focusEvent.getSource();
            String string = (String)JETAController.this.m_txt_values.get(jTextField);
            if (!jTextField.getText().equals(string)) {
                JETAController.this.actionPerformed(jTextField.getName(), new ActionEvent(jTextField, 1001, jTextField.getName()));
            }
        }
    }

    class ComponentChangeListener
    implements ChangeListener {
        ComponentChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JETAController.this.stateChanged(changeEvent);
        }
    }

    class ListListener
    implements ListSelectionListener {
        ListListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JETAController.this.valueChanged(listSelectionEvent);
        }
    }

    class CommandListener
    implements ActionListener {
        CommandListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            String string2 = ((Component)object).getName();
            if (object instanceof JTextField) {
                JTextField jTextField = (JTextField)object;
                JETAController.this.m_txt_values.put(jTextField, jTextField.getText());
            }
            if (!string2.equals(string)) {
                System.out.println("JETAController actionCommand != componentName.  actionCommand: " + string + "  componentName: " + string2);
            }
            JETAController.this.actionPerformed(string2, actionEvent);
        }
    }
}

