/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.classtype;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.MangledContext;
import ghidra.app.util.demangler.microsoft.MicrosoftDemangler;
import ghidra.app.util.demangler.microsoft.MicrosoftMangledContext;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.pdb.classtype.ClassTypeManager;
import ghidra.app.util.pdb.classtype.OwnerParentage;
import ghidra.app.util.pdb.classtype.PlaceholderVirtualBaseTable;
import ghidra.app.util.pdb.classtype.PlaceholderVirtualFunctionTable;
import ghidra.app.util.pdb.classtype.ProgramVirtualBaseTable;
import ghidra.app.util.pdb.classtype.ProgramVirtualFunctionTable;
import ghidra.app.util.pdb.classtype.VirtualBaseTable;
import ghidra.app.util.pdb.classtype.VirtualFunctionTable;
import ghidra.app.util.pdb.classtype.VxtManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Structure;
import ghidra.program.model.gclass.ClassID;
import ghidra.program.model.gclass.ClassUtils;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import mdemangler.MDParsableItem;
import mdemangler.naming.MDQualification;
import mdemangler.naming.MDQualifier;
import mdemangler.object.MDObjectCPP;
import mdemangler.typeinfo.MDTypeInfo;
import mdemangler.typeinfo.MDVBTable;
import mdemangler.typeinfo.MDVFTable;
import mdemangler.typeinfo.MDVxTable;

public class MsVxtManager
extends VxtManager {
    private Program program;
    private Map<String, Address> vxtAddressByMangled;
    private Map<String, ParentageNode> parentageNodeByMangled;
    private Map<ClassID, List<VirtualBaseTable>> vbtsByOwner;
    private Map<ClassID, List<VirtualFunctionTable>> vftsByOwner;
    private Map<ClassID, Map<Address, VirtualBaseTable>> vbtByAddressByOwner;
    private Map<ClassID, Map<Address, VirtualFunctionTable>> vftByAddressByOwner;
    private Map<ClassID, Map<Integer, VirtualBaseTable>> vbtByPtrOrdinalByOwner;
    private Map<ClassID, Map<Integer, VirtualFunctionTable>> vftByPtrOrdinalByOwner;
    private ParentageNode vbtRoot;
    private ParentageNode vftRoot;
    private Map<OwnerParentage, VirtualBaseTable> vbtsByOwnerParentage;
    private Map<OwnerParentage, VirtualFunctionTable> vftsByOwnerParentage;

    public MsVxtManager(ClassTypeManager ctm, Program program) {
        super(ctm);
        this.program = program;
        this.vxtAddressByMangled = new HashMap<String, Address>();
        this.parentageNodeByMangled = new HashMap<String, ParentageNode>();
        this.vbtsByOwner = new HashMap<ClassID, List<VirtualBaseTable>>();
        this.vftsByOwner = new HashMap<ClassID, List<VirtualFunctionTable>>();
        this.vbtByAddressByOwner = new HashMap<ClassID, Map<Address, VirtualBaseTable>>();
        this.vftByAddressByOwner = new HashMap<ClassID, Map<Address, VirtualFunctionTable>>();
        this.vbtByPtrOrdinalByOwner = new HashMap<ClassID, Map<Integer, VirtualBaseTable>>();
        this.vftByPtrOrdinalByOwner = new HashMap<ClassID, Map<Integer, VirtualFunctionTable>>();
        this.vbtRoot = new ParentageNode(null);
        this.vftRoot = new ParentageNode(null);
        this.vbtsByOwnerParentage = new HashMap<OwnerParentage, VirtualBaseTable>();
        this.vftsByOwnerParentage = new HashMap<OwnerParentage, VirtualFunctionTable>();
    }

    public void createTables(DataTypeManager dtm, DataUtilities.ClearDataMode mode) {
        Address addr;
        Structure table;
        ClassID id;
        for (VirtualBaseTable vbt : this.vbtsByOwnerParentage.values()) {
            id = vbt.getOwner();
            table = vbt.createDataType(dtm, ClassUtils.getClassInternalsPath((ClassID)id));
            if (mode == null || !(vbt instanceof ProgramVirtualBaseTable)) continue;
            ProgramVirtualBaseTable pvbt = (ProgramVirtualBaseTable)vbt;
            addr = pvbt.getAddress();
            try {
                DataUtilities.createData((Program)this.program, (Address)addr, (DataType)table, (int)table.getLength(), (DataUtilities.ClearDataMode)mode);
            }
            catch (CodeUnitInsertionException e) {
                Msg.warn((Object)this, (Object)("Could not place VBT at address: " + String.valueOf(addr)));
            }
        }
        for (VirtualFunctionTable vft : this.vftsByOwnerParentage.values()) {
            id = vft.getOwner();
            table = vft.createDataType(dtm, ClassUtils.getClassInternalsPath((ClassID)id));
            if (mode == null || !(vft instanceof ProgramVirtualFunctionTable)) continue;
            ProgramVirtualFunctionTable pvft = (ProgramVirtualFunctionTable)vft;
            addr = pvft.getAddress();
            try {
                DataUtilities.createData((Program)this.program, (Address)addr, (DataType)table, (int)table.getLength(), (DataUtilities.ClearDataMode)mode);
            }
            catch (CodeUnitInsertionException e) {
                Msg.warn((Object)this, (Object)("Could not place VFT at address: " + String.valueOf(addr)));
            }
        }
    }

    public VirtualBaseTable findPrimaryVbt(ClassID owner, List<ClassID> parentage) {
        List<VirtualBaseTable> list = this.vbtsByOwner.get(owner);
        if (list == null) {
            return null;
        }
        VirtualBaseTable result = null;
        VirtualBaseTable firstPlaceholder = null;
        Address addrResult = null;
        for (VirtualBaseTable table : list) {
            if (table instanceof ProgramVirtualBaseTable) {
                ProgramVirtualBaseTable pvbt = (ProgramVirtualBaseTable)table;
                Address addr = pvbt.getAddress();
                if (addrResult != null && addr.compareTo((Object)addrResult) >= 0) continue;
                addrResult = addr;
                result = table;
                continue;
            }
            if (firstPlaceholder != null) continue;
            firstPlaceholder = table;
        }
        if (result == null) {
            if (firstPlaceholder != null) {
                return firstPlaceholder;
            }
            result = new PlaceholderVirtualBaseTable(owner, parentage);
            list.add(result);
        }
        return result;
    }

    public VirtualFunctionTable findPrimaryVft(ClassID owner, List<ClassID> parentage) {
        List<VirtualFunctionTable> list = this.vftsByOwner.get(owner);
        if (list == null) {
            return null;
        }
        VirtualFunctionTable result = null;
        VirtualFunctionTable firstPlaceholder = null;
        Address addrResult = null;
        for (VirtualFunctionTable table : list) {
            if (table instanceof ProgramVirtualFunctionTable) {
                ProgramVirtualFunctionTable pvft = (ProgramVirtualFunctionTable)table;
                Address addr = pvft.getAddress();
                if (addrResult != null && addr.compareTo((Object)addrResult) >= 0) continue;
                addrResult = addr;
                result = table;
                continue;
            }
            if (firstPlaceholder != null) continue;
            firstPlaceholder = table;
        }
        if (result == null) {
            if (firstPlaceholder != null) {
                return firstPlaceholder;
            }
            result = new PlaceholderVirtualFunctionTable(owner, parentage);
            list.add(result);
        }
        return result;
    }

    public ClassID[] getAllVbtOwners() {
        ClassID[] ids = new ClassID[this.vbtsByOwner.size()];
        Set<ClassID> set = this.vbtsByOwner.keySet();
        return set.toArray(ids);
    }

    public ClassID[] getAllVftOwners() {
        ClassID[] ids = new ClassID[this.vftsByOwner.size()];
        Set<ClassID> set = this.vftsByOwner.keySet();
        return set.toArray(ids);
    }

    public VirtualBaseTable[] getVbts(ClassID owner) {
        List<VirtualBaseTable> list = this.vbtsByOwner.get(owner);
        if (list == null) {
            return null;
        }
        return list.toArray(new VirtualBaseTable[list.size()]);
    }

    public VirtualFunctionTable[] getVfts(ClassID owner) {
        List<VirtualFunctionTable> list = this.vftsByOwner.get(owner);
        if (list == null) {
            return null;
        }
        return list.toArray(new VirtualFunctionTable[list.size()]);
    }

    public VirtualBaseTable findVbt(ClassID owner, List<ClassID> parentage, Integer ordinal) {
        OwnerParentage op = new OwnerParentage(owner, parentage);
        VirtualBaseTable vbt = this.vbtsByOwnerParentage.get(op);
        if (vbt != null) {
            return vbt;
        }
        vbt = this.getVbtByAddressOrdinal(owner, ordinal);
        if (vbt == null && (vbt = this.searchVbtTree(owner, parentage)) == null) {
            vbt = new PlaceholderVirtualBaseTable(owner, parentage);
        }
        this.vbtsByOwnerParentage.put(op, vbt);
        this.storeVbt(owner, ordinal, vbt);
        return vbt;
    }

    private VirtualBaseTable getVbtByAddressOrdinal(ClassID owner, Integer ordinal) {
        if (ordinal == null) {
            return null;
        }
        Map<Address, VirtualBaseTable> map = this.vbtByAddressByOwner.get(owner);
        if (map == null) {
            return null;
        }
        int count = 0;
        for (Map.Entry<Address, VirtualBaseTable> entry : map.entrySet()) {
            if (count == ordinal) {
                return entry.getValue();
            }
            ++count;
        }
        return null;
    }

    private VirtualFunctionTable getVftByAddressOrdinal(ClassID owner, Integer ordinal) {
        if (ordinal == null) {
            return null;
        }
        Map<Address, VirtualFunctionTable> map = this.vftByAddressByOwner.get(owner);
        if (map == null) {
            return null;
        }
        int count = 0;
        for (Map.Entry<Address, VirtualFunctionTable> entry : map.entrySet()) {
            if (count == ordinal) {
                return entry.getValue();
            }
            ++count;
        }
        return null;
    }

    private VirtualBaseTable searchVbtTree(ClassID owner, List<ClassID> parentage) {
        ParentageNode node = this.findNode(owner, parentage, this.vbtRoot);
        if (node == null) {
            return null;
        }
        VirtualBaseTable vbTable = node.getVBTable();
        if (vbTable != null || !parentage.isEmpty()) {
            return vbTable;
        }
        node = this.findNode(owner, List.of(owner), this.vbtRoot);
        if (node == null) {
            return null;
        }
        return node.getVBTable();
    }

    public VirtualFunctionTable findVft(ClassID owner, List<ClassID> parentage, Integer ordinal) {
        OwnerParentage op = new OwnerParentage(owner, parentage);
        VirtualFunctionTable vft = this.vftsByOwnerParentage.get(op);
        if (vft != null) {
            return vft;
        }
        vft = this.getVftByAddressOrdinal(owner, ordinal);
        if (vft == null && (vft = this.searchVftTree(owner, parentage)) == null) {
            vft = new PlaceholderVirtualFunctionTable(owner, parentage);
        }
        this.vftsByOwnerParentage.put(op, vft);
        this.storeVft(owner, ordinal, vft);
        return vft;
    }

    private VirtualFunctionTable searchVftTree(ClassID owner, List<ClassID> parentage) {
        ParentageNode node = this.findNode(owner, parentage, this.vftRoot);
        if (node == null) {
            return null;
        }
        VirtualFunctionTable vfTable = node.getVFTable();
        if (vfTable != null || !parentage.isEmpty()) {
            return vfTable;
        }
        node = this.findNode(owner, List.of(owner), this.vftRoot);
        if (node == null) {
            return null;
        }
        return node.getVFTable();
    }

    public void createVirtualTables(CategoryPath categoryPath, Map<String, Address> addressByMangledName, MessageLog log, TaskMonitor monitor) throws CancelledException {
        for (Map.Entry<String, Address> entry : addressByMangledName.entrySet()) {
            Address address;
            monitor.checkCancelled();
            String mangled = entry.getKey();
            if (this.createVirtualTable(categoryPath, mangled, address = entry.getValue(), monitor)) continue;
            log.appendMsg("Could not create VxTable for " + mangled);
        }
    }

    public boolean createVirtualTable(CategoryPath categoryPath, String mangled, Address address, TaskMonitor monitor) {
        Address a = this.vxtAddressByMangled.get(mangled);
        if (a != null) {
            if (!a.equals((Object)address)) {
                Msg.warn((Object)this, (Object)String.format("New address (%s) does not match existing %s for: %s", a, address, mangled));
            } else {
                Msg.warn((Object)this, (Object)String.format("Entry already exists: address (%s), %s", address, mangled));
            }
            return false;
        }
        this.vxtAddressByMangled.put(mangled, address);
        DemanglerResults demanglerResults = MsVxtManager.getOwnerAndUsersDtp(categoryPath, mangled);
        if (demanglerResults == null) {
            Msg.warn((Object)this, (Object)("Problem obtaining path information from mangled symbol: " + mangled));
            return false;
        }
        OwnerAndParentage ownerAndParentage = demanglerResults.ownerAndParentage();
        ClassID owner = ownerAndParentage.owner();
        List<ClassID> parentage = ownerAndParentage.parentage();
        ParentageNode node = this.parentageNodeByMangled.get(mangled);
        if (node == null) {
            ParentageNode root = demanglerResults.vtType().equals((Object)VtType.VBT) ? this.vbtRoot : this.vftRoot;
            node = this.getOrAddParentageNode(categoryPath, root, demanglerResults);
            if (node == null) {
                return false;
            }
            this.parentageNodeByMangled.put(mangled, node);
        }
        switch (demanglerResults.vtType().ordinal()) {
            case 1: {
                ProgramVirtualBaseTable prvbt = new ProgramVirtualBaseTable(owner, parentage, this.program, address, ClassUtils.getVbtEntrySize((DataTypeManager)this.ctm.getDataTypeManager()), mangled);
                if (node.getVBTable() != null) {
                    Msg.warn((Object)this, (Object)("VBT already exists at node for " + mangled));
                    return false;
                }
                node.setVBTable(prvbt);
                this.vbtByAddress.put(address, prvbt);
                this.storeVbt(owner, address, (VirtualBaseTable)prvbt);
                break;
            }
            case 0: {
                ProgramVirtualFunctionTable vft = new ProgramVirtualFunctionTable(owner, parentage, this.program, address, this.ctm.getDefaultVfTableElementSize(), mangled);
                if (node.getVFTable() != null) {
                    Msg.warn((Object)this, (Object)("VFT already exists at node for " + mangled));
                    return false;
                }
                node.setVFTable(vft);
                this.vftByAddress.put(address, vft);
                this.storeVft(owner, address, (VirtualFunctionTable)vft);
                break;
            }
            default: {
                throw new AssertException("Unhandled VtType: " + String.valueOf((Object)demanglerResults.vtType()));
            }
        }
        return true;
    }

    private void storeVbt(ClassID owner, Address address, VirtualBaseTable vbt) {
        List<VirtualBaseTable> list = this.vbtsByOwner.get(owner);
        if (list == null) {
            list = new ArrayList<VirtualBaseTable>();
            this.vbtsByOwner.put(owner, list);
        }
        List<ClassID> parentage = vbt.getParentage();
        for (VirtualBaseTable table : list) {
            if (!this.isEqual(table.getParentage(), parentage)) continue;
            return;
        }
        list.add(vbt);
        Map<Address, VirtualBaseTable> map = this.vbtByAddressByOwner.get(owner);
        if (map == null) {
            map = new TreeMap<Address, VirtualBaseTable>();
            this.vbtByAddressByOwner.put(owner, map);
        }
        if (map.containsKey(address)) {
            Msg.warn((Object)this, (Object)String.format("VBT already exists for owner/address %s/%s", owner.getSymbolPath().toString(), address.toString()));
            return;
        }
        map.put(address, vbt);
    }

    private void storeVbt(ClassID owner, Integer ordinal, VirtualBaseTable vbt) {
        List<VirtualBaseTable> list = this.vbtsByOwner.get(owner);
        if (list == null) {
            list = new ArrayList<VirtualBaseTable>();
            this.vbtsByOwner.put(owner, list);
        }
        List<ClassID> parentage = vbt.getParentage();
        for (VirtualBaseTable table : list) {
            if (!this.isEqual(table.getParentage(), parentage)) continue;
            return;
        }
        list.add(vbt);
        if (ordinal == null) {
            return;
        }
        Map<Integer, VirtualBaseTable> map = this.vbtByPtrOrdinalByOwner.get(owner);
        if (map == null) {
            map = new TreeMap<Integer, VirtualBaseTable>();
            this.vbtByPtrOrdinalByOwner.put(owner, map);
        }
        if (map.containsKey(ordinal)) {
            Msg.warn((Object)this, (Object)String.format("VBT already exists for owner/ordinal %s/%d ", owner.getSymbolPath().toString(), ordinal));
            return;
        }
        map.put(ordinal, vbt);
    }

    private void storeVft(ClassID owner, Address address, VirtualFunctionTable vft) {
        List<VirtualFunctionTable> list = this.vftsByOwner.get(owner);
        if (list == null) {
            list = new ArrayList<VirtualFunctionTable>();
            this.vftsByOwner.put(owner, list);
        }
        List<ClassID> parentage = vft.getParentage();
        for (VirtualFunctionTable table : list) {
            if (!this.isEqual(table.getParentage(), parentage)) continue;
            return;
        }
        list.add(vft);
        Map<Address, VirtualFunctionTable> map = this.vftByAddressByOwner.get(owner);
        if (map == null) {
            map = new TreeMap<Address, VirtualFunctionTable>();
            this.vftByAddressByOwner.put(owner, map);
        }
        if (map.containsKey(address)) {
            Msg.warn((Object)this, (Object)String.format("VFT already exists for owner/address %s/%s", owner.getSymbolPath().toString(), address.toString()));
            return;
        }
        map.put(address, vft);
    }

    private void storeVft(ClassID owner, Integer ordinal, VirtualFunctionTable vft) {
        List<VirtualFunctionTable> list = this.vftsByOwner.get(owner);
        if (list == null) {
            list = new ArrayList<VirtualFunctionTable>();
            this.vftsByOwner.put(owner, list);
        }
        List<ClassID> parentage = vft.getParentage();
        for (VirtualFunctionTable table : list) {
            if (!this.isEqual(table.getParentage(), parentage)) continue;
            return;
        }
        list.add(vft);
        if (ordinal == null) {
            return;
        }
        Map<Integer, VirtualFunctionTable> map = this.vftByPtrOrdinalByOwner.get(owner);
        if (map == null) {
            map = new TreeMap<Integer, VirtualFunctionTable>();
            this.vftByPtrOrdinalByOwner.put(owner, map);
        }
        if (map.containsKey(ordinal)) {
            Msg.warn((Object)this, (Object)String.format("VFT already exists for owner/ptrOffset %s/%d", owner.getSymbolPath().toString(), ordinal));
            return;
        }
        map.put(ordinal, vft);
    }

    private boolean isEqual(List<ClassID> parentage1, List<ClassID> parentage2) {
        int diff = parentage1.size() - parentage2.size();
        if (diff != 0) {
            return false;
        }
        Iterator<ClassID> iter2 = parentage2.iterator();
        for (ClassID element : parentage1) {
            if (element.equals((Object)iter2.next())) continue;
            return false;
        }
        return true;
    }

    private ParentageNode findNode(ClassID owner, List<ClassID> parentage, ParentageNode root) {
        SymbolPath ownerSp = owner.getSymbolPath();
        ParentageNode ownerNode = root.getBranch(ownerSp.toString());
        if (ownerNode == null) {
            return null;
        }
        ParentageNode resultNode = null;
        ParentageNode node = ownerNode;
        for (ClassID id : parentage) {
            SymbolPath sp = id.getSymbolPath();
            ParentageNode next = node.getBranch(sp.toString());
            if (next == null) continue;
            resultNode = node = next;
        }
        if (resultNode == null) {
            return ownerNode;
        }
        return resultNode;
    }

    private ParentageNode getOrAddParentageNode(CategoryPath categoryPath, ParentageNode root, DemanglerResults demanglerResults) {
        ParentageNode node = root;
        OwnerAndParentage ownerAndParentage = demanglerResults.ownerAndParentage();
        ClassID owner = ownerAndParentage.owner();
        List<ClassID> parentage = ownerAndParentage.parentage();
        node = node.getOrAddBranch(owner.getSymbolPath().toString());
        for (ClassID id : parentage) {
            node = node.getOrAddBranch(id.getSymbolPath().toString());
        }
        return node;
    }

    private static MDParsableItem doDemangle(String mangledString) {
        MicrosoftDemangler demangler = new MicrosoftDemangler();
        MicrosoftMangledContext context = demangler.createMangledContext(mangledString, null, null, null);
        try {
            DemangledObject demangledObject = demangler.demangle((MangledContext)context);
            if (demangledObject == null) {
                return null;
            }
            return demangler.getMdItem();
        }
        catch (DemangledException e) {
            return null;
        }
    }

    private static DemanglerResults getOwnerAndUsersDtp(CategoryPath categoryPath, String mangledString) {
        MDParsableItem parsableItem = MsVxtManager.doDemangle(mangledString);
        if (!(parsableItem instanceof MDObjectCPP)) {
            return null;
        }
        MDObjectCPP cppItem = (MDObjectCPP)parsableItem;
        MDTypeInfo typeInfo = cppItem.getTypeInfo();
        if (!(typeInfo instanceof MDVxTable)) {
            return null;
        }
        MDVxTable vxTable = (MDVxTable)typeInfo;
        SymbolPath ownerSp = MsVxtManager.getOwnerSymbolPath(cppItem.getQualification());
        List<SymbolPath> parentageSps = MsVxtManager.getParentageSymbolPaths(vxTable.getNestedQualifications());
        ArrayList<ClassID> parentage = new ArrayList<ClassID>();
        ClassID owner = new ClassID(categoryPath, ownerSp);
        for (SymbolPath sp : parentageSps) {
            ClassID user = new ClassID(categoryPath, sp);
            parentage.add(user);
        }
        OwnerAndParentage ownerAndParentage = new OwnerAndParentage(owner, parentage);
        MDTypeInfo mDTypeInfo = typeInfo;
        Objects.requireNonNull(mDTypeInfo);
        MDTypeInfo mDTypeInfo2 = mDTypeInfo;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MDVFTable.class, MDVBTable.class}, (Object)mDTypeInfo2, n)) {
            case 0 -> {
                MDVFTable f = (MDVFTable)mDTypeInfo2;
                yield new DemanglerResults(VtType.VFT, ownerAndParentage);
            }
            case 1 -> {
                MDVBTable b = (MDVBTable)mDTypeInfo2;
                yield new DemanglerResults(VtType.VBT, ownerAndParentage);
            }
            default -> null;
        };
    }

    private static List<SymbolPath> getParentageSymbolPaths(List<MDQualification> qualifications) {
        if (qualifications == null) {
            return null;
        }
        ArrayList<SymbolPath> paths = new ArrayList<SymbolPath>();
        for (MDQualification qualification : qualifications) {
            SymbolPath symbolPath = MsVxtManager.getOwnerSymbolPath(qualification);
            paths.add(symbolPath);
        }
        return paths;
    }

    private static SymbolPath getOwnerSymbolPath(MDQualification qualification) {
        Iterator it = qualification.iterator();
        if (!it.hasNext()) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        do {
            MDQualifier qual = (MDQualifier)it.next();
            parts.add(0, qual.toString());
        } while (it.hasNext());
        return new SymbolPath(parts);
    }

    private static class ParentageNode {
        private ParentageNode parent = null;
        private Map<String, ParentageNode> branches;
        private String name;
        private VirtualFunctionTable vft;
        private VirtualBaseTable vbt;

        private ParentageNode(String name) {
            this.name = name;
            this.branches = new HashMap<String, ParentageNode>();
        }

        private ParentageNode getOrAddBranch(String branchName) {
            ParentageNode branch = this.branches.get(branchName);
            if (branch == null) {
                branch = new ParentageNode(branchName);
                branch.parent = this;
                this.branches.put(branchName, branch);
            }
            return branch;
        }

        private ParentageNode getBranch(String branchName) {
            return this.branches.get(branchName);
        }

        private void setVFTable(VirtualFunctionTable vftArg) {
            this.vft = vftArg;
        }

        private void setVBTable(VirtualBaseTable vbtArg) {
            this.vbt = vbtArg;
        }

        private VirtualFunctionTable getVFTable() {
            return this.vft;
        }

        private VirtualBaseTable getVBTable() {
            return this.vbt;
        }

        private String getName() {
            return this.name;
        }

        private ParentageNode getParent() {
            return this.parent;
        }
    }

    private record DemanglerResults(VtType vtType, OwnerAndParentage ownerAndParentage) {
    }

    private record OwnerAndParentage(ClassID owner, List<ClassID> parentage) {
    }

    private static enum VtType {
        VFT,
        VBT;

    }
}

