/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractOemDefinableStringMsType
extends AbstractMsType {
    protected int msAssignedOEMIdentifier;
    protected int oemAssignedTypeIdentifier;
    protected List<RecordNumber> recordNumbers;
    protected byte[] remainingBytes;

    public AbstractOemDefinableStringMsType(AbstractPdb pdb, PdbByteReader reader, int intSize) throws PdbException {
        super(pdb, reader);
        this.msAssignedOEMIdentifier = reader.parseUnsignedShortVal();
        this.oemAssignedTypeIdentifier = reader.parseUnsignedShortVal();
        this.recordNumbers = new ArrayList<RecordNumber>();
        int count = reader.parseVarSizedCount(intSize);
        for (int i = 0; i < count; ++i) {
            RecordNumber aRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, intSize);
            this.recordNumbers.add(aRecordNumber);
        }
        this.remainingBytes = reader.parseBytesRemaining();
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append("OEM Definable String\n");
        builder.append(String.format("  MSFT-assigned OEM Identifier: %s\n", this.msAssignedOEMIdentifier));
        builder.append(String.format("  OEM-assigned Identifier: %s\n", this.oemAssignedTypeIdentifier));
        builder.append(String.format("  count: %d\n", this.recordNumbers.size()));
        for (int i = 0; i < this.recordNumbers.size(); ++i) {
            builder.append(String.format("    recordNumber[%d]: 0x%08x\n", i, this.recordNumbers.get(i).getNumber()));
        }
        builder.append(String.format("  additional data length: %d\n", this.remainingBytes.length));
    }
}

