/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.msf;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.Msf;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MsfStream {
    public static final int MAX_STREAM_LENGTH = Integer.MAX_VALUE;
    public static final int NIL_STREAM_NUMBER = 65535;
    protected int streamLength;
    protected List<Integer> pageList = new ArrayList<Integer>();
    protected Msf msf;

    public int getLength() {
        return this.streamLength;
    }

    public byte[] read(int streamOffset, int numToRead) throws IOException, CancelledException {
        if (numToRead <= 0) {
            return null;
        }
        byte[] bytes = new byte[numToRead];
        this.read(streamOffset, bytes, 0, numToRead);
        return bytes;
    }

    public void read(int streamOffset, byte[] bytes, int bytesOffset, int numToRead) throws IOException, CancelledException {
        if (streamOffset < 0 || streamOffset > this.streamLength) {
            throw new IOException("Offset out of range.");
        }
        if (numToRead > this.streamLength - streamOffset) {
            throw new IOException("Not enough data left.");
        }
        if (numToRead <= 0) {
            return;
        }
        int remainingByteCount = numToRead;
        int pageNumber = streamOffset >> this.msf.getLog2PageSize();
        int offsetIntoPage = streamOffset & this.msf.getPageSizeModMask();
        if (offsetIntoPage != 0) {
            int firstNumToRead = Math.min(this.msf.getPageSize() - offsetIntoPage, remainingByteCount);
            this.msf.getFileReader().read(this.pageList.get(pageNumber), offsetIntoPage, firstNumToRead, bytes, bytesOffset);
            if (remainingByteCount - firstNumToRead > remainingByteCount) {
                throw new IOException("Integer count underflow when preparing to read.");
            }
            remainingByteCount -= firstNumToRead;
            ++pageNumber;
            bytesOffset += firstNumToRead;
        }
        while (remainingByteCount > 0) {
            int numToReadInPage;
            int firstSequentialPageNumber;
            this.msf.checkCancelled();
            int lastSequentialPageNumber = firstSequentialPageNumber = this.pageList.get(pageNumber).intValue();
            int numToReadInSequentialPages = 0;
            do {
                this.msf.checkCancelled();
                numToReadInPage = Math.min(this.msf.getPageSize(), remainingByteCount);
                numToReadInSequentialPages += numToReadInPage;
            } while ((remainingByteCount -= numToReadInPage) > 0 && this.pageList.get(++pageNumber) == ++lastSequentialPageNumber);
            this.msf.getFileReader().read(firstSequentialPageNumber, 0, numToReadInSequentialPages, bytes, bytesOffset);
            bytesOffset += numToReadInSequentialPages;
        }
    }

    public String dump(int maxOut) {
        int outputLength = Math.min(this.getLength(), maxOut);
        StringBuilder builder = new StringBuilder();
        builder.append("Length: ");
        builder.append(this.getLength());
        builder.append(String.format(" (0x%08x)", this.getLength()));
        if (outputLength <= 0) {
            return "";
        }
        byte[] bytes = new byte[outputLength];
        try {
            this.read(0, bytes, 0, outputLength);
        }
        catch (IOException e) {
            throw new AssertException("Total bonkers: PDB Stream does not contain advertised data");
        }
        catch (CancelledException e) {
            throw new AssertException("CancelledException Thrown");
        }
        int i = 0;
        while (i < outputLength) {
            builder.append(String.format("\n%06x", i));
            for (int j = 0; j < 16 && i < outputLength; ++j, ++i) {
                builder.append(String.format(" %02x", bytes[i]));
            }
        }
        return builder.toString();
    }

    MsfStream(Msf msf) {
        this.streamLength = -1;
        this.msf = msf;
    }

    MsfStream(Msf msf, int streamLength) {
        this.msf = msf;
        this.streamLength = streamLength;
    }

    void deserializeStreamLengthAndMapTableAddress(PdbByteReader reader) throws PdbException {
        this.streamLength = reader.parseInt();
        reader.parseInt();
    }

    void deserializePageNumbers(PdbByteReader reader) throws PdbException, CancelledException {
        block4: {
            int numPages;
            block5: {
                numPages = Msf.floorDivisionWithLog2Divisor(this.streamLength, this.msf.getLog2PageSize());
                if (this.msf.getPageNumberSize() != 2) break block5;
                for (int i = 0; i < numPages; ++i) {
                    this.msf.checkCancelled();
                    int pageNumber = reader.parseUnsignedShortVal();
                    if (pageNumber != 0) {
                        this.pageList.add(pageNumber);
                        continue;
                    }
                    break block4;
                }
                break block4;
            }
            if (this.msf.getPageNumberSize() != 4) break block4;
            for (int i = 0; i < numPages; ++i) {
                this.msf.checkCancelled();
                int pageNumber = reader.parseInt();
                if (pageNumber != 0) {
                    this.pageList.add(pageNumber);
                    continue;
                }
                break;
            }
        }
    }

    void deserializeStreamInfo(PdbByteReader reader) throws IOException, PdbException, CancelledException {
        this.deserializeStreamLengthAndMapTableAddress(reader);
        this.deserializePageNumbers(reader);
    }

    Integer getStreamOffsetForAbsoluteFileOffset(long fileOffset) {
        long pageSize = this.msf.getPageSize();
        for (int pageCount = 0; pageCount < this.pageList.size(); ++pageCount) {
            int page = this.pageList.get(pageCount);
            long pageStart = (long)page * pageSize;
            long pageEndExclusive = pageStart + pageSize;
            if (pageStart > fileOffset || fileOffset >= pageEndExclusive) continue;
            Long pageOffset = fileOffset - pageStart;
            Long streamOffset = (long)pageCount * pageSize + pageOffset;
            return streamOffset.intValue();
        }
        return null;
    }
}

