/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13CrossScopeImport;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.CrossScopeExportsC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CrossScopeImportsC13Section
extends C13Section {
    private List<C13CrossScopeImport> crossScopeImports = new ArrayList<C13CrossScopeImport>();

    static CrossScopeImportsC13Section parse(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws PdbException, CancelledException {
        return new CrossScopeImportsC13Section(reader, ignore, monitor);
    }

    private CrossScopeImportsC13Section(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws CancelledException, PdbException {
        super(ignore);
        while (reader.numRemaining() >= C13CrossScopeImport.getBaseRecordSize()) {
            monitor.checkCancelled();
            C13CrossScopeImport crossImport = new C13CrossScopeImport(reader);
            this.crossScopeImports.add(crossImport);
        }
        if (reader.hasMore()) {
            Msg.debug(CrossScopeExportsC13Section.class, (Object)String.format("Num Extra C13CrossScopeExports bytes: %d", reader.numRemaining()));
        }
    }

    public List<C13CrossScopeImport> getCrossScopeImports() {
        return this.crossScopeImports;
    }

    public String toString() {
        return String.format("%s: num cross-scope imports = %d", this.getClass().getSimpleName(), this.crossScopeImports.size());
    }

    @Override
    protected void dumpInternal(Writer writer, TaskMonitor monitor) throws IOException, CancelledException {
        for (C13CrossScopeImport crossScopeImport : this.crossScopeImports) {
            monitor.checkCancelled();
            writer.write(crossScopeImport.toString());
            writer.write(10);
        }
    }
}

