/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedMap;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundleRevisionImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.hooks.weaving.WovenClassListener;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

class WeavingHooks {
    private final FrameworkContext fwCtx;
    ServiceTracker<WeavingHook, TrackedWeavingHook> weavingHookTracker;
    ServiceTracker<WovenClassListener, WovenClassListener> listenerTracker;

    WeavingHooks(FrameworkContext fwCtx) {
        this.fwCtx = fwCtx;
    }

    synchronized void open() {
        if (this.fwCtx.debug.hooks) {
            this.fwCtx.debug.println("Begin Tracking Weaving Hooks");
        }
        this.weavingHookTracker = new ServiceTracker<WeavingHook, TrackedWeavingHook>((BundleContext)this.fwCtx.systemBundle.bundleContext, WeavingHook.class, new ServiceTrackerCustomizer<WeavingHook, TrackedWeavingHook>(){
            int cnt = 0;

            @Override
            public TrackedWeavingHook addingService(ServiceReference<WeavingHook> reference) {
                if (this.cnt++ == 0) {
                    WeavingHooks.this.openListener();
                }
                return new TrackedWeavingHook(((WeavingHooks)WeavingHooks.this).fwCtx.systemBundle.bundleContext.getService(reference), reference);
            }

            @Override
            public void modifiedService(ServiceReference<WeavingHook> reference, TrackedWeavingHook service) {
            }

            @Override
            public void removedService(ServiceReference<WeavingHook> reference, TrackedWeavingHook service) {
                if (--this.cnt == 0) {
                    WeavingHooks.this.closeListener();
                }
            }
        });
        this.weavingHookTracker.open();
    }

    private void openListener() {
        this.listenerTracker = new ServiceTracker((BundleContext)this.fwCtx.systemBundle.bundleContext, WovenClassListener.class, null);
        this.listenerTracker.open();
    }

    synchronized void close() {
        this.weavingHookTracker.close();
        this.weavingHookTracker = null;
    }

    private void closeListener() {
        this.listenerTracker.close();
        this.listenerTracker = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callHooks(WovenClassImpl wc) throws Exception {
        SortedMap<ServiceReference<WeavingHook>, TrackedWeavingHook> hooks;
        boolean ok = false;
        if (wc.isWeavingComplete()) {
            throw new RuntimeException("ERROR!!");
        }
        WeavingHooks weavingHooks = this;
        synchronized (weavingHooks) {
            if (this.weavingHookTracker == null) {
                return;
            }
            hooks = this.weavingHookTracker.getTracked();
        }
        try {
            for (TrackedWeavingHook twh : hooks.values()) {
                if (twh.isBlackListed()) continue;
                try {
                    twh.weave(wc);
                }
                catch (WeavingException we) {
                    this.fwCtx.frameworkError(twh.reference.getBundle(), (Throwable)we, new FrameworkListener[0]);
                    ClassFormatError cfe = new ClassFormatError("WeavingException thrown: " + we.getMessage() + " by hook " + twh.getClass().getName());
                    cfe.initCause(we);
                    throw cfe;
                }
                catch (Throwable t) {
                    this.fwCtx.frameworkError(twh.reference.getBundle(), t, new FrameworkListener[0]);
                    twh.blacklist();
                    ClassFormatError cfe = new ClassFormatError("Exception throw: " + t + " while calling hook " + twh.getClass().getName());
                    cfe.initCause(t);
                    throw cfe;
                }
            }
            ok = true;
        }
        finally {
            wc.markAsComplete(ok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callListeners(WovenClassImpl wc) {
        ServiceReference<WovenClassListener>[] srs;
        WovenClassListener wcl = this.fwCtx.perm.getWovenClassListener();
        if (wcl != null) {
            wcl.modified(wc);
        }
        WeavingHooks weavingHooks = this;
        synchronized (weavingHooks) {
            if (this.listenerTracker == null) {
                return;
            }
            srs = this.listenerTracker.getServiceReferences();
        }
        if (srs != null) {
            for (ServiceReference<WovenClassListener> wlsr : srs) {
                try {
                    this.fwCtx.systemBundle.bundleContext.getService(wlsr).modified(wc);
                }
                catch (Throwable t) {
                    this.fwCtx.frameworkWarning(wlsr.getBundle(), t, new FrameworkListener[0]);
                }
            }
        }
    }

    public static class DynamicListIterator
    implements ListIterator<String> {
        private final WovenClassImpl parent;
        private final ListIterator<String> org;

        public DynamicListIterator(WovenClassImpl parent, ListIterator<String> org) {
            this.parent = parent;
            this.org = org;
        }

        @Override
        public void add(String elem) {
            this.checkChangeAllowed(elem);
            this.org.add(elem);
        }

        @Override
        public boolean hasNext() {
            return this.org.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.org.hasPrevious();
        }

        @Override
        public String next() {
            return this.org.next();
        }

        @Override
        public int nextIndex() {
            return this.org.nextIndex();
        }

        @Override
        public String previous() {
            return this.org.previous();
        }

        @Override
        public int previousIndex() {
            return this.org.previousIndex();
        }

        @Override
        public void remove() {
            this.checkChangeAllowed(null);
            this.org.remove();
        }

        @Override
        public void set(String elem) {
            this.checkChangeAllowed(elem);
            this.org.set(elem);
        }

        private void checkChangeAllowed(String elem) throws UnsupportedOperationException {
            if (this.parent.isWeavingComplete()) {
                throw new IllegalStateException("Parent WovenClass is frozen");
            }
            this.parent.bundle.fwCtx.perm.checkWeaveAdminPerm(this.parent.bundle);
            if (elem != null) {
                this.parent.bundle.fwCtx.perm.checkImportPackagePermission(elem);
            }
        }
    }

    public static class DynamicImportList
    implements List<String> {
        private final List<String> org;
        private final WovenClassImpl parent;

        public DynamicImportList(WovenClassImpl parent) {
            this.parent = parent;
            this.org = new ArrayList<String>();
        }

        public DynamicImportList(WovenClassImpl parent, List<String> subList) {
            this.parent = parent;
            this.org = subList;
        }

        @Override
        public boolean add(String elem) {
            this.checkChangeAllowed(Collections.singletonList(elem));
            return this.org.add(elem);
        }

        @Override
        public void add(int index, String elem) {
            this.checkChangeAllowed(Collections.singletonList(elem));
            this.org.add(index, elem);
        }

        @Override
        public boolean addAll(Collection<? extends String> elems) {
            this.checkChangeAllowed(elems);
            return this.org.addAll(elems);
        }

        @Override
        public boolean addAll(int index, Collection<? extends String> elems) {
            this.checkChangeAllowed(elems);
            return this.org.addAll(index, elems);
        }

        @Override
        public void clear() {
            this.checkChangeAllowed(null);
            this.org.clear();
        }

        @Override
        public boolean contains(Object elem) {
            return this.org.contains(elem);
        }

        @Override
        public boolean containsAll(Collection<?> elems) {
            return this.org.containsAll(elems);
        }

        @Override
        public String get(int index) {
            return this.org.get(index);
        }

        @Override
        public int indexOf(Object elem) {
            return this.org.indexOf(elem);
        }

        @Override
        public boolean isEmpty() {
            return this.org.isEmpty();
        }

        @Override
        public Iterator<String> iterator() {
            return new DynamicListIterator(this.parent, this.org.listIterator());
        }

        @Override
        public int lastIndexOf(Object elem) {
            return this.org.lastIndexOf(elem);
        }

        @Override
        public ListIterator<String> listIterator() {
            return new DynamicListIterator(this.parent, this.org.listIterator());
        }

        @Override
        public ListIterator<String> listIterator(int index) {
            return new DynamicListIterator(this.parent, this.org.listIterator(index));
        }

        @Override
        public String remove(int index) {
            this.checkChangeAllowed(null);
            return this.org.remove(index);
        }

        @Override
        public boolean remove(Object elem) {
            this.checkChangeAllowed(null);
            return this.org.remove(elem);
        }

        @Override
        public boolean removeAll(Collection<?> elems) {
            this.checkChangeAllowed(null);
            return this.org.removeAll(elems);
        }

        @Override
        public boolean retainAll(Collection<?> elems) {
            this.checkChangeAllowed(null);
            return this.org.removeAll(elems);
        }

        @Override
        public String set(int index, String elem) {
            this.checkChangeAllowed(Collections.singletonList(elem));
            return this.org.set(index, elem);
        }

        @Override
        public int size() {
            return this.org.size();
        }

        @Override
        public List<String> subList(int from, int to) {
            return new DynamicImportList(this.parent, this.org.subList(from, to));
        }

        @Override
        public Object[] toArray() {
            return this.org.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.org.toArray(a);
        }

        private void checkChangeAllowed(Collection<? extends String> elems) throws UnsupportedOperationException {
            if (this.parent.isWeavingComplete()) {
                throw new IllegalStateException("Parent WovenClass is frozen");
            }
            this.parent.bundle.fwCtx.perm.checkWeaveAdminPerm(this.parent.bundle);
            if (elems != null) {
                for (String string : elems) {
                    this.parent.bundle.fwCtx.perm.checkImportPackagePermission(string);
                }
            }
        }
    }

    static class WovenClassImpl
    implements WovenClass {
        final BundleImpl bundle;
        final String name;
        byte[] current;
        int state = 1;
        Class<?> c = null;
        final List<String> dynamicImports = new DynamicImportList(this);

        WovenClassImpl(BundleImpl bundle, String name, byte[] initial) {
            this.bundle = bundle;
            this.name = name;
            this.current = initial;
        }

        @Override
        public byte[] getBytes() {
            this.bundle.fwCtx.perm.checkWeaveAdminPerm(this.bundle);
            if (this.state == 1) {
                return this.current;
            }
            byte[] r = new byte[this.current.length];
            System.arraycopy(this.current, 0, r, 0, this.current.length);
            return r;
        }

        @Override
        public void setBytes(byte[] newBytes) {
            this.bundle.fwCtx.perm.checkWeaveAdminPerm(this.bundle);
            if ((this.state & 0x1E) != 0) {
                throw new IllegalStateException("Trying to call WovenClass.setBytes(byte[]) after weaving is complete");
            }
            if (newBytes == null) {
                throw new NullPointerException("Trying to call WovenClass.setBytes(byte[]) with null newBytes");
            }
            this.current = newBytes;
        }

        @Override
        public List<String> getDynamicImports() {
            return this.dynamicImports;
        }

        @Override
        public boolean isWeavingComplete() {
            return (this.state & 0x1C) != 0;
        }

        @Override
        public String getClassName() {
            return this.name;
        }

        @Override
        public ProtectionDomain getProtectionDomain() {
            return this.c == null ? null : this.c.getProtectionDomain();
        }

        @Override
        public Class<?> getDefinedClass() {
            return this.c;
        }

        @Override
        public BundleWiring getBundleWiring() {
            BundleRevisionImpl br = this.bundle.current().bundleRevision;
            if (br != null) {
                return br.getWiring();
            }
            return null;
        }

        @Override
        public int getState() {
            return this.state;
        }

        void markAsComplete(boolean ok) {
            this.state = ok ? 2 : 8;
            this.bundle.fwCtx.weavingHooks.callListeners(this);
        }

        void setDefinedClass(Class<?> c) {
            this.state = c != null ? 4 : 16;
            this.c = c;
            this.bundle.fwCtx.weavingHooks.callListeners(this);
        }

        public String toString() {
            return "WovenClass[" + this.name + ", " + this.toString(this.dynamicImports) + ", byte[" + this.current.length + "]=" + this.current + "]";
        }

        String getDynamicImportsAsString() {
            StringBuffer sb = new StringBuffer();
            for (String s : this.dynamicImports) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(s);
            }
            return sb.toString();
        }

        String toString(List<String> sl) {
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            for (String s : sl) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append(s);
            }
            sb.append(")");
            return sb.toString();
        }

        public boolean hasAdditionalDynamicImports() {
            return !this.dynamicImports.isEmpty();
        }
    }

    static class TrackedWeavingHook
    implements WeavingHook {
        final WeavingHook tracked;
        final ServiceReference<WeavingHook> reference;
        boolean blacklisted = false;

        TrackedWeavingHook(WeavingHook tracked, ServiceReference<WeavingHook> reference) {
            this.tracked = tracked;
            this.reference = reference;
        }

        @Override
        public void weave(WovenClass wovenClass) {
            this.tracked.weave(wovenClass);
        }

        void blacklist() {
            this.blacklisted = true;
        }

        boolean isBlackListed() {
            return this.blacklisted;
        }
    }
}

