/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.propertymap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.infonode.properties.propertymap.PropertyMapImpl;
import net.infonode.properties.propertymap.value.PropertyValue;
import net.infonode.util.Utils;
import net.infonode.util.ValueChange;
import net.infonode.util.collection.map.base.ConstMap;
import net.infonode.util.collection.map.base.ConstMapIterator;

public class PropertyMapManager {
    private static final PropertyMapManager INSTANCE = new PropertyMapManager();
    private HashMap changes;
    private int batchCounter;

    public static PropertyMapManager getInstance() {
        return INSTANCE;
    }

    void addMapChanges(PropertyMapImpl propertyMap, ConstMap mapChanges) {
        HashMap<Object, ValueChange> map = (HashMap<Object, ValueChange>)this.changes.get(propertyMap);
        if (map == null) {
            map = new HashMap<Object, ValueChange>();
            this.changes.put(propertyMap, map);
        }
        ConstMapIterator iterator = mapChanges.constIterator();
        while (iterator.atEntry()) {
            Object oldValue;
            ValueChange vc = (ValueChange)iterator.getValue();
            Object key = iterator.getKey();
            Object newValue = vc.getNewValue() == null ? null : ((PropertyValue)vc.getNewValue()).getWithDefault(propertyMap);
            Object value = map.get(key);
            Object object = value == null ? (vc.getOldValue() == null ? null : ((PropertyValue)vc.getOldValue()).getWithDefault(propertyMap)) : (oldValue = ((ValueChange)value).getOldValue());
            if (!Utils.equals(oldValue, newValue)) {
                map.put(iterator.getKey(), new ValueChange(oldValue, newValue));
            } else if (value != null) {
                map.remove(key);
            }
            iterator.next();
        }
    }

    public static void runBatch(Runnable runnable) {
        PropertyMapManager.getInstance().beginBatch();
        try {
            runnable.run();
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
    }

    public void beginBatch() {
        if (this.batchCounter++ == 0) {
            this.changes = new HashMap();
        }
    }

    private void addTreeChanges(PropertyMapImpl map, PropertyMapImpl modifiedMap, HashMap changes, HashMap treeChanges) {
        HashMap<PropertyMapImpl, HashMap> changeMap = (HashMap<PropertyMapImpl, HashMap>)treeChanges.get(map);
        if (changeMap == null) {
            changeMap = new HashMap<PropertyMapImpl, HashMap>();
            treeChanges.put(map, changeMap);
        }
        changeMap.put(modifiedMap, changes);
        if (map.getParent() != null) {
            this.addTreeChanges(map.getParent(), modifiedMap, changes, treeChanges);
        }
    }

    public void endBatch() {
        if (--this.batchCounter == 0) {
            HashMap objectChanges;
            PropertyMapImpl object;
            HashMap treeChanges = new HashMap();
            HashMap localChanges = this.changes;
            this.changes = null;
            for (Map.Entry entry : localChanges.entrySet()) {
                object = (PropertyMapImpl)entry.getKey();
                objectChanges = (HashMap)entry.getValue();
                if (objectChanges.isEmpty()) continue;
                object.firePropertyValuesChanged(Collections.unmodifiableMap(objectChanges));
                this.addTreeChanges(object, object, objectChanges, treeChanges);
            }
            for (Map.Entry entry : treeChanges.entrySet()) {
                object = (PropertyMapImpl)entry.getKey();
                objectChanges = (HashMap)entry.getValue();
                if (objectChanges.isEmpty()) continue;
                object.firePropertyTreeValuesChanged(Collections.unmodifiableMap(objectChanges));
            }
        }
    }
}

