/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import java.util.LinkedHashMap;
import java.util.Map;

class DistinctTargetDependencyFilter {
    Map<String, Dependency> seen = new LinkedHashMap<String, Dependency>();

    DistinctTargetDependencyFilter() {
    }

    Dependency knownDependency(Dependency element) {
        String comparedDescription = this.getDescriptionForComparison(element);
        Dependency existing = this.seen.putIfAbsent(comparedDescription, element);
        return existing != null ? existing : element;
    }

    private String getDescriptionForComparison(Dependency dependency) {
        return dependency.getOriginClass().getName() + " " + this.removeOrigin(dependency.getDescription()).replaceFirst(":\\d+\\)$", ")");
    }

    private String removeOrigin(String inputString) {
        int openDelimiters = 0;
        boolean started = false;
        for (int i = 0; i < inputString.length(); ++i) {
            char charAt = inputString.charAt(i);
            if (charAt == '<') {
                if (!started) {
                    started = true;
                }
                ++openDelimiters;
                continue;
            }
            if (charAt != '>' || !started || --openDelimiters != 0) continue;
            return inputString.substring(i + 1);
        }
        return inputString;
    }
}

