/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.math.BigInteger;

public class OtpErlangLong
extends OtpErlangObject {
    private static final long serialVersionUID = 1610466859236755096L;
    private long val;
    private BigInteger bigVal = null;

    public OtpErlangLong(long l) {
        this.val = l;
    }

    public OtpErlangLong(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new NullPointerException();
        }
        if (bigInteger.bitLength() < 64) {
            this.val = bigInteger.longValue();
        } else {
            this.bigVal = bigInteger;
        }
    }

    public OtpErlangLong(OtpInputStream otpInputStream) throws OtpErlangDecodeException {
        byte[] byArray = otpInputStream.read_integer_byte_array();
        try {
            this.val = OtpInputStream.byte_array_to_long(byArray, false);
        }
        catch (OtpErlangDecodeException otpErlangDecodeException) {
            this.bigVal = new BigInteger(byArray);
        }
    }

    public BigInteger bigIntegerValue() {
        if (this.bigVal != null) {
            return this.bigVal;
        }
        return BigInteger.valueOf(this.val);
    }

    public long longValue() {
        if (this.bigVal != null) {
            return this.bigVal.longValue();
        }
        return this.val;
    }

    public boolean isLong() {
        if (this.bigVal != null) {
            return this.bigVal.bitLength() < 64;
        }
        return true;
    }

    public boolean isULong() {
        if (this.bigVal != null) {
            return this.bigVal.signum() >= 0 && this.bigVal.bitLength() <= 64;
        }
        return this.val >= 0L;
    }

    public int bitLength() {
        if (this.bigVal != null) {
            return this.bigVal.bitLength();
        }
        if (this.val == 0L || this.val == -1L) {
            return 0;
        }
        int n = 32;
        long l = (1L << n) - 1L;
        if (this.val < 0L) {
            l ^= 0xFFFFFFFFFFFFFFFFL;
            for (int i = n >> 1; i > 0; i >>= 1) {
                if ((this.val | l) == this.val) {
                    n -= i;
                    l >>= i;
                    continue;
                }
                n += i;
                l <<= i;
            }
            if ((this.val | l) != this.val) {
                ++n;
            }
        } else {
            for (int i = n >> 1; i > 0; i >>= 1) {
                if ((this.val & l) == this.val) {
                    n -= i;
                    l >>= i;
                    continue;
                }
                n += i;
                l = l << i | l;
            }
            if ((this.val & l) != this.val) {
                ++n;
            }
        }
        return n;
    }

    public int signum() {
        if (this.bigVal != null) {
            return this.bigVal.signum();
        }
        return this.val > 0L ? 1 : (this.val < 0L ? -1 : 0);
    }

    public int intValue() throws OtpErlangRangeException {
        long l = this.longValue();
        int n = (int)l;
        if ((long)n != l) {
            throw new OtpErlangRangeException("Value too large for int: " + this.val);
        }
        return n;
    }

    public int uIntValue() throws OtpErlangRangeException {
        long l = this.longValue();
        int n = (int)l;
        if ((long)n != l) {
            throw new OtpErlangRangeException("Value too large for int: " + this.val);
        }
        if (n < 0) {
            throw new OtpErlangRangeException("Value not positive: " + this.val);
        }
        return n;
    }

    public short shortValue() throws OtpErlangRangeException {
        long l = this.longValue();
        short s = (short)l;
        if ((long)s != l) {
            throw new OtpErlangRangeException("Value too large for short: " + this.val);
        }
        return s;
    }

    public short uShortValue() throws OtpErlangRangeException {
        long l = this.longValue();
        short s = (short)l;
        if ((long)s != l) {
            throw new OtpErlangRangeException("Value too large for short: " + this.val);
        }
        if (s < 0) {
            throw new OtpErlangRangeException("Value not positive: " + this.val);
        }
        return s;
    }

    public char charValue() throws OtpErlangRangeException {
        long l = this.longValue();
        char c = (char)l;
        if ((long)c != l) {
            throw new OtpErlangRangeException("Value too large for char: " + this.val);
        }
        return c;
    }

    public byte byteValue() throws OtpErlangRangeException {
        long l = this.longValue();
        byte by = (byte)l;
        if ((long)by != l) {
            throw new OtpErlangRangeException("Value too large for byte: " + this.val);
        }
        return by;
    }

    @Override
    public String toString() {
        if (this.bigVal != null) {
            return String.valueOf(this.bigVal);
        }
        return "" + this.val;
    }

    @Override
    public void encode(OtpOutputStream otpOutputStream) {
        if (this.bigVal != null) {
            otpOutputStream.write_big_integer(this.bigVal);
        } else {
            otpOutputStream.write_long(this.val);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OtpErlangLong)) {
            return false;
        }
        OtpErlangLong otpErlangLong = (OtpErlangLong)object;
        if (this.bigVal != null && otpErlangLong.bigVal != null) {
            return this.bigVal.equals(otpErlangLong.bigVal);
        }
        if (this.bigVal == null && otpErlangLong.bigVal == null) {
            return this.val == otpErlangLong.val;
        }
        return false;
    }

    @Override
    protected int doHashCode() {
        if (this.bigVal != null) {
            return this.bigVal.hashCode();
        }
        return BigInteger.valueOf(this.val).hashCode();
    }
}

