/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;

public final class StringUtils {
    private StringUtils() {
    }

    @Nullable
    public static String quoteStringIfNotQuoted(@Nullable String value) {
        if (CommonUtils.isEmpty(value)) {
            return value;
        }
        boolean isQuoted = value.startsWith("'") && value.endsWith("'");
        return isQuoted ? value : "'" + value + "'";
    }

    public static String wrap(String str, int wrapLength) {
        int offset = 0;
        StringBuilder resultBuilder = new StringBuilder();
        while (str.length() - offset > wrapLength) {
            if (str.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int spaceToWrapAt = str.lastIndexOf(32, wrapLength + offset);
            if (spaceToWrapAt < offset && (spaceToWrapAt = str.indexOf(32, wrapLength + offset)) < 0) break;
            resultBuilder.append(str, offset, spaceToWrapAt);
            resultBuilder.append("\n");
            offset = spaceToWrapAt + 1;
        }
        resultBuilder.append(str.substring(offset));
        return resultBuilder.toString();
    }

    public static String truncateToSpace(String str, int wrapLength) {
        int spaceToWrapAt = str.indexOf(32, wrapLength);
        if (spaceToWrapAt < 0) {
            return str;
        }
        return str.substring(0, spaceToWrapAt) + "...";
    }

    @NotNull
    public static String truncateText(@NotNull String str, int maxLength) {
        if (str.length() > maxLength) {
            return str.substring(0, maxLength) + "...";
        }
        return str;
    }

    @Nullable
    public static String underscoreToCamelCase(@Nullable String str) {
        if (CommonUtils.isEmpty(str)) {
            return str;
        }
        StringBuilder result = new StringBuilder(str.length());
        boolean toUpper = false;
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch == '_') {
                toUpper = true;
            } else if (toUpper) {
                result.append(Character.toUpperCase(ch));
                toUpper = false;
            } else {
                result.append(Character.toLowerCase(ch));
            }
            ++i;
        }
        return result.toString();
    }

    @Nullable
    public static String firstNonEmpty(@Nullable String a, @Nullable String b) {
        return CommonUtils.isEmpty(a) ? b : a;
    }
}

