/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class TrayIconHandler {
    private static final Log log = Log.getLog(TrayIconHandler.class);
    private TrayIcon trayItem;

    public static boolean isSupported() {
        return SystemTray.isSupported();
    }

    public void show() {
        Path logoFile;
        if (this.trayItem != null) {
            return;
        }
        try {
            logoFile = RuntimeUtils.getPlatformFile((String)UIIcon.DBEAVER_LOGO.getLocation());
        }
        catch (IOException e2) {
            log.error((Object)e2);
            return;
        }
        this.trayItem = new TrayIcon(Toolkit.getDefaultToolkit().getImage(logoFile.toAbsolutePath().toString()));
        this.trayItem.setImageAutoSize(true);
        PopupMenu popupMenu = new PopupMenu();
        MenuItem showItem = new MenuItem("Show DBeaver");
        showItem.addActionListener(e -> this.showMainWindow());
        popupMenu.add(showItem);
        this.trayItem.setPopupMenu(popupMenu);
        this.trayItem.addActionListener(e -> {});
        this.trayItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    TrayIconHandler.this.showMainWindow();
                }
            }
        });
        this.trayItem.setToolTip(GeneralUtils.getProductTitle());
        try {
            SystemTray.getSystemTray().add(this.trayItem);
        }
        catch (AWTException e3) {
            log.error((Object)e3);
        }
    }

    private void showMainWindow() {
        UIUtils.asyncExec(() -> {
            Shell activeShell = UIUtils.getActiveWorkbenchShell();
            if (activeShell != null) {
                if (activeShell.getMinimized()) {
                    activeShell.setMinimized(false);
                }
                activeShell.forceActive();
            }
        });
    }

    public void hide() {
        if (this.trayItem != null) {
            SystemTray.getSystemTray().remove(this.trayItem);
            this.trayItem = null;
        }
    }

    public void notify(String message, int status) {
        try {
            if (this.trayItem == null) {
                try {
                    this.show();
                }
                catch (Exception e) {
                    log.warn((Object)"Can't show tray item", (Throwable)e);
                    return;
                }
            }
            TrayIcon.MessageType type = switch (status) {
                case 1 -> TrayIcon.MessageType.INFO;
                case 4 -> TrayIcon.MessageType.ERROR;
                case 2 -> TrayIcon.MessageType.WARNING;
                default -> TrayIcon.MessageType.NONE;
            };
            this.trayItem.displayMessage(GeneralUtils.getProductTitle(), message, type);
        }
        catch (Throwable e) {
            log.error((Object)"Error showing tray notification", e);
        }
    }
}

