/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har.post;

import edu.umass.cs.benchlab.har.post.HarPostTextLine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HarPostTextLines {
    private String start = "Content-Type: multipart/form-data; boundary=";
    private String boundary = "---------------------------12655665101227410282340966306";
    private long contentLength;
    private ArrayList<HarPostTextLine> lines;

    public HarPostTextLines(String s) {
        this(-1L);
        String[] tokens;
        assert (s.startsWith("Content-Type: multipart/form-data;"));
        Pattern p = Pattern.compile(".*boundary=(\\-+\\d+)\\r\\n.*");
        Matcher m = p.matcher(s);
        if (m.find()) {
            this.boundary = m.group(1);
        } else {
            System.err.println("Error in detecting boundary in Raw Trace\n");
            System.exit(-1);
        }
        for (String string : tokens = s.split("--" + this.boundary)) {
            String pattern = "\\r\\nContent-Disposition: form-data; name=\"(.*)\"";
            p = Pattern.compile(pattern);
            m = p.matcher(string);
            if (!m.find()) continue;
            String fieldName = m.group(1);
            String[] tmpS = string.split(fieldName + "\\\"");
            String fieldValue = tmpS[1];
            fieldValue = fieldValue.substring(4, fieldValue.length() - 2);
            this.addLine(fieldName, fieldValue);
        }
    }

    public HarPostTextLines(long contentLength) {
        this.contentLength = contentLength;
        this.lines = new ArrayList();
    }

    public HarPostTextLines(long contentLength, String boundary) {
        this(contentLength);
        this.boundary = boundary;
    }

    public void addLine(String name, String value) {
        HarPostTextLine hptl = new HarPostTextLine(name, value, this.boundary);
        this.lines.add(hptl);
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public List<HarPostTextLine> getLines() {
        return this.lines;
    }

    public String toString() {
        String out = this.start + this.boundary + "\r\n" + "Content-Length: " + this.contentLength + "\r\n" + "\r\n";
        Iterator<HarPostTextLine> i = this.lines.iterator();
        while (i.hasNext()) {
            out = out + i.next().toString();
        }
        out = out + "--" + this.boundary + "--" + "\r\n";
        return out;
    }
}

