/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.ArraySort;
import com.microsoft.z3.BitVecSort;
import com.microsoft.z3.BoolSort;
import com.microsoft.z3.CharSort;
import com.microsoft.z3.Context;
import com.microsoft.z3.DatatypeSort;
import com.microsoft.z3.FPRMSort;
import com.microsoft.z3.FPSort;
import com.microsoft.z3.FiniteDomainSort;
import com.microsoft.z3.IntSort;
import com.microsoft.z3.Native;
import com.microsoft.z3.ReSort;
import com.microsoft.z3.RealSort;
import com.microsoft.z3.RelationSort;
import com.microsoft.z3.SeqSort;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.UninterpretedSort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_ast_kind;
import com.microsoft.z3.enumerations.Z3_sort_kind;

public class Sort
extends AST {
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Sort)) {
            return false;
        }
        Sort sort = (Sort)object;
        return this.getContext().nCtx() == sort.getContext().nCtx() && Native.isEqSort(this.getContext().nCtx(), this.getNativeObject(), sort.getNativeObject());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int getId() {
        return Native.getSortId(this.getContext().nCtx(), this.getNativeObject());
    }

    public Z3_sort_kind getSortKind() {
        return Z3_sort_kind.fromInt(Native.getSortKind(this.getContext().nCtx(), this.getNativeObject()));
    }

    public Symbol getName() {
        return Symbol.create(this.getContext(), Native.getSortName(this.getContext().nCtx(), this.getNativeObject()));
    }

    @Override
    public String toString() {
        return Native.sortToString(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    public Sort translate(Context context) {
        return (Sort)super.translate(context);
    }

    Sort(Context context, long l) {
        super(context, l);
    }

    @Override
    void checkNativeObject(long l) {
        if (Native.getAstKind(this.getContext().nCtx(), l) != Z3_ast_kind.Z3_SORT_AST.toInt()) {
            throw new Z3Exception("Underlying object is not a sort");
        }
        super.checkNativeObject(l);
    }

    static Sort create(Context context, long l) {
        Z3_sort_kind z3_sort_kind = Z3_sort_kind.fromInt(Native.getSortKind(context.nCtx(), l));
        switch (z3_sort_kind) {
            case Z3_ARRAY_SORT: {
                return new ArraySort(context, l);
            }
            case Z3_BOOL_SORT: {
                return new BoolSort(context, l);
            }
            case Z3_BV_SORT: {
                return new BitVecSort(context, l);
            }
            case Z3_DATATYPE_SORT: {
                return new DatatypeSort(context, l);
            }
            case Z3_INT_SORT: {
                return new IntSort(context, l);
            }
            case Z3_REAL_SORT: {
                return new RealSort(context, l);
            }
            case Z3_UNINTERPRETED_SORT: {
                return new UninterpretedSort(context, l);
            }
            case Z3_FINITE_DOMAIN_SORT: {
                return new FiniteDomainSort(context, l);
            }
            case Z3_RELATION_SORT: {
                return new RelationSort(context, l);
            }
            case Z3_FLOATING_POINT_SORT: {
                return new FPSort(context, l);
            }
            case Z3_ROUNDING_MODE_SORT: {
                return new FPRMSort(context, l);
            }
            case Z3_SEQ_SORT: {
                return new SeqSort(context, l);
            }
            case Z3_RE_SORT: {
                return new ReSort(context, l);
            }
            case Z3_CHAR_SORT: {
                return new CharSort(context, l);
            }
        }
        throw new Z3Exception("Unknown sort kind");
    }
}

