/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.converter.IdentityConverter;
import org.apache.sis.internal.converter.SystemRegistry;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.Static;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.Containers;

public final class ObjectConverters
extends Static {
    private ObjectConverters() {
    }

    public static <T> ObjectConverter<T, T> identity(Class<T> clazz) {
        ArgumentChecks.ensureNonNull("type", clazz);
        return new IdentityConverter<T, T>(clazz, clazz, null).unique();
    }

    public static <S, T> ObjectConverter<? super S, ? extends T> find(Class<S> clazz, Class<T> clazz2) throws UnconvertibleObjectException {
        ArgumentChecks.ensureNonNull("source", clazz);
        ArgumentChecks.ensureNonNull("target", clazz2);
        return SystemRegistry.INSTANCE.find(clazz, clazz2);
    }

    public static <T> T convert(Object object, Class<T> clazz) throws UnconvertibleObjectException {
        ArgumentChecks.ensureNonNull("target", clazz);
        if (!clazz.isInstance(object) && object != null) {
            object = SystemRegistry.INSTANCE.find(object.getClass(), clazz).apply(object);
        }
        return (T)object;
    }

    public static <S, E> Set<E> derivedSet(Set<S> set, ObjectConverter<S, E> objectConverter) {
        return Containers.derivedSet(set, objectConverter);
    }

    public static <SK, SV, K, V> Map<K, V> derivedMap(Map<SK, SV> map, ObjectConverter<SK, K> objectConverter, ObjectConverter<SV, V> objectConverter2) {
        return Containers.derivedMap(map, objectConverter, objectConverter2);
    }

    public static <SK, K, V> Map<K, V> derivedKeys(Map<SK, V> map, ObjectConverter<SK, K> objectConverter, Class<V> clazz) {
        ArgumentChecks.ensureNonNull("valueType", clazz);
        return Containers.derivedMap(map, objectConverter, ObjectConverters.identity(clazz));
    }

    public static <K, SV, V> Map<K, V> derivedValues(Map<K, SV> map, Class<K> clazz, ObjectConverter<SV, V> objectConverter) {
        ArgumentChecks.ensureNonNull("keyType", clazz);
        return Containers.derivedMap(map, ObjectConverters.identity(clazz), objectConverter);
    }
}

