/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.solr.api.Api;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.model.LogLevelChange;
import org.apache.solr.client.api.model.LoggingResponse;
import org.apache.solr.client.api.model.SetThresholdRequestBody;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.AdminHandlersProxy;
import org.apache.solr.handler.admin.api.NodeLogging;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingHandler
extends RequestHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final LogWatcher<?> watcher;
    private final CoreContainer cc;

    public LoggingHandler(CoreContainer cc) {
        this.cc = cc;
        this.watcher = cc.getLogging();
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String since;
        String[] set;
        NodeLogging loggingApi = new NodeLogging(this.cc);
        SolrParams params = req.getParams();
        if (params.get("threshold") != null) {
            this.squashV2Response(rsp, loggingApi.setMessageThreshold(new SetThresholdRequestBody(params.get("threshold"))));
        }
        if (params.get("test") != null) {
            NodeLogging.writeLogsForTesting();
        }
        if ((set = params.getParams("set")) != null) {
            List<LogLevelChange> changes = NodeLogging.parseLogLevelChanges(set);
            this.squashV2Response(rsp, loggingApi.modifyLocalLogLevel(changes));
        }
        if ((since = req.getParams().get("since")) != null) {
            long time = -1L;
            try {
                time = Long.parseLong(since);
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid timestamp: " + since);
            }
            this.squashV2Response(rsp, (LoggingResponse)loggingApi.fetchLocalLogMessages(time));
        } else {
            this.squashV2Response(rsp, (LoggingResponse)loggingApi.listAllLoggersAndLevels());
        }
        rsp.setHttpCaching(false);
        if (this.cc != null && AdminHandlersProxy.maybeProxyToNodes(req, rsp, this.cc)) {
            return;
        }
    }

    private void squashV2Response(SolrQueryResponse rsp, LoggingResponse response) {
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, response);
    }

    @Override
    public String getDescription() {
        return "Logging Handler";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public Collection<Api> getApis() {
        return new ArrayList<Api>();
    }

    @Override
    public Collection<Class<? extends JerseyResource>> getJerseyResources() {
        return List.of(NodeLogging.class);
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        if (request.getParams().get("set") != null) {
            return PermissionNameProvider.Name.CONFIG_EDIT_PERM;
        }
        return PermissionNameProvider.Name.CONFIG_READ_PERM;
    }
}

