/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.util.Arrays;

public final class MutableCharArray
implements CharSequence,
Cloneable {
    private static final char[] EMPTY = new char[0];
    private char[] buffer;
    private int length;
    private int start;
    private int hash;

    public MutableCharArray() {
        this.reset(EMPTY);
    }

    public MutableCharArray(CharSequence seq) {
        this.reset(seq);
    }

    public MutableCharArray(char[] buffer) {
        this.reset(buffer, 0, buffer.length);
    }

    public MutableCharArray(char[] buffer, int start, int length) {
        this.reset(buffer, start, length);
    }

    public void reset(CharSequence seq) {
        if (this.buffer == null || this.buffer.length < seq.length()) {
            this.buffer = new char[seq.length()];
        }
        this.length = seq.length();
        this.start = 0;
        for (int i = 0; i < this.length; ++i) {
            this.buffer[i] = seq.charAt(i);
        }
        this.hash = MutableCharArray.hashCode(this.buffer, this.start, this.length);
    }

    public void reset(char[] buffer) {
        this.reset(buffer, 0, buffer.length);
    }

    public void reset(char[] buffer, int start, int length) {
        this.length = length;
        this.start = start;
        this.buffer = buffer;
        this.hash = MutableCharArray.hashCode(buffer, start, length);
    }

    public void reset() {
        this.reset(EMPTY);
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    public int getStart() {
        return this.start;
    }

    @Override
    public final char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[this.start + index];
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public MutableCharArray subSequence(int start, int end) {
        return new MutableCharArray(this.buffer, start, end - start);
    }

    @Override
    public String toString() {
        return new String(this.buffer, this.start, this.length);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object other) {
        return other == this || this.getClass().isInstance(other) && this.equals((MutableCharArray)this.getClass().cast(other));
    }

    public final boolean equals(MutableCharArray other) {
        return this.hash == other.hash && this.length == other.length && Arrays.equals(this.buffer, this.start, this.start + this.length, other.buffer, other.start, other.start + other.length);
    }

    public static final int hashCode(char[] buffer, int start, int length) {
        int h = 0;
        for (int i = length - 1; i >= 0; --i) {
            h = 31 * h + buffer[start++];
        }
        return h;
    }

    public MutableCharArray clone() {
        if (this.length == 0) {
            return new MutableCharArray();
        }
        char[] cloned = new char[this.length];
        System.arraycopy(this.buffer, this.start, cloned, 0, this.length);
        return new MutableCharArray(cloned);
    }

    public char[] toArray() {
        return Arrays.copyOfRange(this.getBuffer(), this.getStart(), this.length());
    }
}

