/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.attrs;

import java.util.List;
import org.carrot2.attrs.Attr;
import org.carrot2.attrs.Constraint;

public class AttrDouble
extends Attr<Double> {
    private AttrDouble(Double value, List<? extends Constraint<? super Double>> constraint, String label) {
        super(value, label, constraint);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Attr.BuilderScaffold<Double> {
        public Builder min(double minInclusive) {
            this.addConstraint(Constraint.named("value >= " + minInclusive, v -> {
                if (v != null && v < minInclusive) {
                    throw new IllegalArgumentException("Value must be >= " + minInclusive + ": " + v);
                }
            }));
            return this;
        }

        public Builder max(double maxInclusive) {
            this.addConstraint(Constraint.named("value <= " + maxInclusive, v -> {
                if (v != null && v > maxInclusive) {
                    throw new IllegalArgumentException("Value must be <= " + maxInclusive + ": " + v);
                }
            }));
            return this;
        }

        public Builder label(String label) {
            super.label(label);
            return this;
        }

        public AttrDouble defaultValue(Double defaultValue) {
            return new AttrDouble(defaultValue, this.getConstraint(), this.label);
        }
    }
}

