/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.Experimental;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ContentType;
import dev.langchain4j.data.text.TextFile;
import dev.langchain4j.internal.ValidationUtils;
import java.net.URI;
import java.util.Objects;

@Experimental
public class TextFileContent
implements Content {
    private final TextFile textFile;

    @Override
    public ContentType type() {
        return ContentType.TEXT_FILE;
    }

    public TextFileContent(URI url) {
        this.textFile = TextFile.builder().url(ValidationUtils.ensureNotNull(url, "url")).build();
    }

    public TextFileContent(String url) {
        this(URI.create(url));
    }

    public TextFileContent(String base64Data, String mimeType) {
        this.textFile = TextFile.builder().base64Data(ValidationUtils.ensureNotBlank(base64Data, "base64data")).mimeType(mimeType).build();
    }

    public TextFileContent(TextFile textFile) {
        this.textFile = textFile;
    }

    public TextFile textFile() {
        return this.textFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextFileContent that = (TextFileContent)o;
        return Objects.equals(this.textFile, that.textFile);
    }

    public int hashCode() {
        return Objects.hash(this.textFile);
    }

    public String toString() {
        return "TextFileContent { textFile = " + this.textFile + " }";
    }

    public static TextFileContent from(URI url) {
        return new TextFileContent(url);
    }

    public static TextFileContent from(String url) {
        return new TextFileContent(url);
    }

    public static TextFileContent from(String base64Data, String mimeType) {
        return new TextFileContent(base64Data, mimeType);
    }

    public static TextFileContent from(TextFile textFile) {
        return new TextFileContent(textFile);
    }
}

