/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsResponse;
import software.amazon.awssdk.services.ec2.model.IpamPoolCidr;

public class GetIpamPoolCidrsIterable
implements SdkIterable<GetIpamPoolCidrsResponse> {
    private final Ec2Client client;
    private final GetIpamPoolCidrsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetIpamPoolCidrsIterable(Ec2Client client, GetIpamPoolCidrsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetIpamPoolCidrsResponseFetcher();
    }

    public Iterator<GetIpamPoolCidrsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IpamPoolCidr> ipamPoolCidrs() {
        Function<GetIpamPoolCidrsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamPoolCidrs() != null) {
                return response.ipamPoolCidrs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetIpamPoolCidrsResponseFetcher
    implements SyncPageFetcher<GetIpamPoolCidrsResponse> {
        private GetIpamPoolCidrsResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamPoolCidrsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetIpamPoolCidrsResponse nextPage(GetIpamPoolCidrsResponse previousPage) {
            if (previousPage == null) {
                return GetIpamPoolCidrsIterable.this.client.getIpamPoolCidrs(GetIpamPoolCidrsIterable.this.firstRequest);
            }
            return GetIpamPoolCidrsIterable.this.client.getIpamPoolCidrs((GetIpamPoolCidrsRequest)((Object)GetIpamPoolCidrsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

