/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.transport.client.node.NodeClient;

public class RestCatAction
extends BaseRestHandler {
    private static final String CAT = "=^.^=";
    private static final String CAT_NL = "=^.^=\n";
    private final String HELP;

    public RestCatAction(List<AbstractCatAction> catActions) {
        StringBuilder sb = new StringBuilder();
        sb.append(CAT_NL);
        for (AbstractCatAction catAction : catActions) {
            catAction.documentation(sb);
        }
        this.HELP = sb.toString();
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_cat"));
    }

    @Override
    public String getName() {
        return "cat_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return channel -> channel.sendResponse(new BytesRestResponse(RestStatus.OK, this.HELP));
    }
}

