/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.Internal;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.internal.util.config.ConfigurationHelper;

@Internal
public class MySQLServerConfiguration {
    private final int bytesPerCharacter;
    private final boolean noBackslashEscapesEnabled;

    public MySQLServerConfiguration(int bytesPerCharacter, boolean noBackslashEscapesEnabled) {
        this.bytesPerCharacter = bytesPerCharacter;
        this.noBackslashEscapesEnabled = noBackslashEscapesEnabled;
    }

    public int getBytesPerCharacter() {
        return this.bytesPerCharacter;
    }

    public boolean isNoBackslashEscapesEnabled() {
        return this.noBackslashEscapesEnabled;
    }

    static Integer getBytesPerCharacter(String characterSet) {
        int collationIndex = characterSet.indexOf(95);
        return switch (collationIndex == -1 ? characterSet : characterSet.substring(0, collationIndex)) {
            case "utf16", "utf16le", "utf32", "utf8mb4", "gb18030" -> 4;
            case "utf8", "utf8mb3", "eucjpms", "ujis" -> 3;
            case "ucs2", "cp932", "big5", "euckr", "gb2312", "gbk", "sjis" -> 2;
            default -> 1;
        };
    }

    public static MySQLServerConfiguration fromDialectResolutionInfo(DialectResolutionInfo info) {
        Integer bytesPerCharacter = null;
        Boolean noBackslashEscapes = null;
        DatabaseMetaData databaseMetaData = info.getDatabaseMetadata();
        if (databaseMetaData != null) {
            try (Statement statement = databaseMetaData.getConnection().createStatement();){
                ResultSet resultSet = statement.executeQuery("SELECT @@character_set_database, @@sql_mode");
                if (resultSet.next()) {
                    String characterSet = resultSet.getString(1);
                    bytesPerCharacter = MySQLServerConfiguration.getBytesPerCharacter(characterSet);
                    String sqlMode = resultSet.getString(2);
                    noBackslashEscapes = sqlMode.toLowerCase().contains("no_backslash_escapes");
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (bytesPerCharacter == null) {
            bytesPerCharacter = ConfigurationHelper.getInt("hibernate.dialect.mysql.bytes_per_character", info.getConfigurationValues(), 4);
        }
        if (noBackslashEscapes == null) {
            noBackslashEscapes = ConfigurationHelper.getBoolean("hibernate.dialect.mysql.no_backslash_escapes", info.getConfigurationValues(), false);
        }
        return new MySQLServerConfiguration(bytesPerCharacter, noBackslashEscapes);
    }

    @Deprecated(since="6.4", forRemoval=true)
    public static MySQLServerConfiguration fromDatabaseMetadata(DatabaseMetaData databaseMetaData) {
        int bytesPerCharacter = 4;
        boolean noBackslashEscapes = false;
        if (databaseMetaData != null) {
            try (Statement statement = databaseMetaData.getConnection().createStatement();){
                ResultSet resultSet = statement.executeQuery("SELECT @@character_set_database, @@sql_mode");
                if (resultSet.next()) {
                    String characterSet = resultSet.getString(1);
                    bytesPerCharacter = MySQLServerConfiguration.getBytesPerCharacter(characterSet);
                    String sqlMode = resultSet.getString(2);
                    if (sqlMode.toLowerCase().contains("no_backslash_escapes")) {
                        noBackslashEscapes = true;
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return new MySQLServerConfiguration(bytesPerCharacter, noBackslashEscapes);
    }
}

