/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.annotations.MapKeyType;
import org.hibernate.annotations.Parameter;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.usertype.UserType;

public class MapKeyTypeAnnotation
implements MapKeyType {
    private Class<? extends UserType<?>> value;
    private Parameter[] parameters;

    public MapKeyTypeAnnotation(ModelsContext modelContext) {
        this.parameters = new Parameter[0];
    }

    public MapKeyTypeAnnotation(MapKeyType annotation, ModelsContext modelContext) {
        this.value = annotation.value();
        this.parameters = (Parameter[])OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.MAP_KEY_TYPE, "parameters", modelContext);
    }

    public MapKeyTypeAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.value = (Class)attributeValues.get("value");
        this.parameters = (Parameter[])attributeValues.get("parameters");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return MapKeyType.class;
    }

    @Override
    public Class<? extends UserType<?>> value() {
        return this.value;
    }

    public void value(Class<? extends UserType<?>> value) {
        this.value = value;
    }

    @Override
    public Parameter[] parameters() {
        return this.parameters;
    }

    public void parameters(Parameter[] value) {
        this.parameters = value;
    }
}

