/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;

@Listener
public class SessionAffinityService<K>
implements Supplier<K> {
    public static final int MAX_ATTEMPTS = 32;
    private static final AtomicReferenceFieldUpdater<SessionAffinityService, Topology> UPDATER = AtomicReferenceFieldUpdater.newUpdater(SessionAffinityService.class, Topology.class, "topology");
    private final Supplier<K> generator;
    private final KeyPartitioner keyPartitioner;
    private final Address localAddress;
    private volatile Topology topology = new Topology(IntSets.immutableEmptySet(), -1);

    public SessionAffinityService(Supplier<K> generator, KeyPartitioner keyPartitioner, Address localAddress) {
        this.generator = Objects.requireNonNull(generator);
        this.keyPartitioner = Objects.requireNonNull(keyPartitioner);
        this.localAddress = Objects.requireNonNull(localAddress);
    }

    public static <T> Supplier<T> create(Cache<T, ?> cache, Supplier<T> generator) {
        if (generator == null || !cache.getCacheConfiguration().clustering().cacheMode().isClustered()) {
            return generator;
        }
        SessionAffinityService<T> affinityService = new SessionAffinityService<T>(generator, (KeyPartitioner)ComponentRegistry.componentOf(cache, KeyPartitioner.class), cache.getCacheManager().getAddress());
        cache.addListener(affinityService);
        LocalizedCacheTopology cacheTopology = cache.getAdvancedCache().getDistributionManager().getCacheTopology();
        affinityService.computeTopology(cacheTopology.getWriteConsistentHash(), cacheTopology.getTopologyId());
        return affinityService;
    }

    @Override
    public K get() {
        Topology currentTopology = this.topology;
        if (currentTopology.segments.isEmpty()) {
            return this.generator.get();
        }
        for (int i = 0; i < 32; ++i) {
            K key = this.generator.get();
            if (!currentTopology.segments.contains(this.keyPartitioner.getSegment(key))) continue;
            return key;
        }
        return this.generator.get();
    }

    @TopologyChanged
    public void handleViewChange(TopologyChangedEvent<K, ?> tce) {
        if (tce.isPre()) {
            return;
        }
        this.computeTopology(tce.getWriteConsistentHashAtEnd(), tce.getNewTopologyId());
    }

    private void computeTopology(ConsistentHash consistentHash, int topologyId) {
        Set segments = consistentHash.getPrimarySegmentsForOwner(this.localAddress);
        if (segments.isEmpty()) {
            segments = consistentHash.getSegmentsForOwner(this.localAddress);
        }
        Topology newTopology = new Topology(IntSets.from((Set)segments), topologyId);
        UPDATER.updateAndGet(this, newTopology::chooseLatest);
    }

    private record Topology(IntSet segments, int topologId) {
        private Topology {
            Objects.requireNonNull(segments);
        }

        public Topology chooseLatest(Topology other) {
            return this.topologId > other.topologId ? this : other;
        }
    }
}

