/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Nationalized;
import org.keycloak.models.jpa.entities.RoleAttributeEntity;

@Entity
@Table(name="KEYCLOAK_ROLE", uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "CLIENT_REALM_CONSTRAINT"})})
@NamedQueries(value={@NamedQuery(name="getClientRoles", query="select role from RoleEntity role where role.clientId = :client order by role.name"), @NamedQuery(name="getClientRoleIds", query="select role.id from RoleEntity role where role.clientId = :client"), @NamedQuery(name="getClientRoleByName", query="select role from RoleEntity role where role.name = :name and role.clientId = :client"), @NamedQuery(name="getClientRoleIdByName", query="select role.id from RoleEntity role where role.name = :name and role.clientId = :client"), @NamedQuery(name="searchForClientRoles", query="select role from RoleEntity role where role.clientId = :client and ( lower(role.name) like :search or lower(role.description) like :search ) order by role.name"), @NamedQuery(name="getRealmRoles", query="select role from RoleEntity role where role.clientRole = false and role.realmId = :realm order by role.name"), @NamedQuery(name="getRealmRoleIds", query="select role.id from RoleEntity role where role.clientRole = false and role.realmId = :realm"), @NamedQuery(name="getRealmRoleByName", query="select role from RoleEntity role where role.clientRole = false and role.name = :name and role.realmId = :realm"), @NamedQuery(name="getRealmRoleIdByName", query="select role.id from RoleEntity role where role.clientRole = false and role.name = :name and role.realmId = :realm"), @NamedQuery(name="searchForRealmRoles", query="select role from RoleEntity role where role.clientRole = false and role.realmId = :realm and ( lower(role.name) like :search or lower(role.description) like :search ) order by role.name"), @NamedQuery(name="getRoleIdsFromIdList", query="select role.id from RoleEntity role where role.realmId = :realm and role.id in :ids order by role.name ASC"), @NamedQuery(name="getRoleIdsByNameContainingFromIdList", query="select role.id from RoleEntity role where role.realmId = :realm and lower(role.name) like lower(concat('%',:search,'%')) and role.id in :ids order by role.name ASC"), @NamedQuery(name="getChildRoles", query="select r from RoleEntity r join CompositeRoleEntity c on r.id = c.childRole.id where c.parentRole.id = :parentRoleId")})
public class RoleEntity {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    private String id;
    @Nationalized
    @Column(name="NAME")
    private String name;
    @Nationalized
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="REALM_ID")
    private String realmId;
    @Column(name="CLIENT_ROLE")
    private boolean clientRole;
    @Column(name="CLIENT")
    private String clientId;
    @Column(name="CLIENT_REALM_CONSTRAINT", length=36)
    private String clientRealmConstraint;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=false, mappedBy="role")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    protected List<RoleAttributeEntity> attributes = new LinkedList<RoleAttributeEntity>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
        this.clientRealmConstraint = realmId;
    }

    public List<RoleAttributeEntity> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new LinkedList<RoleAttributeEntity>();
        }
        return this.attributes;
    }

    public void setAttributes(List<RoleAttributeEntity> attributes) {
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isClientRole() {
        return this.clientRole;
    }

    public void setClientRole(boolean clientRole) {
        this.clientRole = clientRole;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
        this.clientRealmConstraint = clientId;
    }

    public String getClientRealmConstraint() {
        return this.clientRealmConstraint;
    }

    public void setClientRealmConstraint(String clientRealmConstraint) {
        this.clientRealmConstraint = clientRealmConstraint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof RoleEntity)) {
            return false;
        }
        RoleEntity that = (RoleEntity)o;
        return this.id.equals(that.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

