/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.crypto.KeyWrapper;

public class PublicKeysWrapper {
    private final List<KeyWrapper> keys;
    private final Long expirationTime;
    public static final PublicKeysWrapper EMPTY = new PublicKeysWrapper(Collections.emptyList());

    public PublicKeysWrapper(List<KeyWrapper> keys) {
        this(keys, null);
    }

    public PublicKeysWrapper(List<KeyWrapper> keys, Long expirationTime) {
        this.keys = keys;
        this.expirationTime = expirationTime;
    }

    public Long getExpirationTime() {
        return this.expirationTime;
    }

    public List<KeyWrapper> getKeys() {
        return this.keys;
    }

    public List<String> getKids() {
        return this.keys.stream().map(KeyWrapper::getKid).collect(Collectors.toList());
    }

    public KeyWrapper getKeyByKidAndAlg(String kid, String alg) {
        Stream<KeyWrapper> potentialMatches = Stream.concat(this.keys.stream().filter(keyWrapper -> Objects.equals(kid, keyWrapper.getKid()) && Objects.equals(alg, keyWrapper.getAlgorithm())), this.keys.stream().filter(keyWrapper -> Objects.equals(kid, keyWrapper.getKid())));
        if (kid == null) {
            potentialMatches = Stream.of(potentialMatches, this.keys.stream().filter(keyWrapper -> Objects.equals(alg, keyWrapper.getAlgorithmOrDefault())), this.keys.stream().filter(KeyWrapper::isDefaultClientCertificate)).flatMap(i -> i);
        }
        return potentialMatches.findFirst().orElse(null);
    }

    public KeyWrapper getKeyByPredicate(Predicate<KeyWrapper> predicate) {
        return this.keys.stream().filter(predicate).findFirst().orElse(null);
    }
}

