/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableKTableAbstractJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableAbstractJoinValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KTableKTableLeftJoin<K, V1, V2, VOut>
extends KTableKTableAbstractJoin<K, V1, V2, VOut> {
    private static final Logger LOG = LoggerFactory.getLogger(KTableKTableLeftJoin.class);

    KTableKTableLeftJoin(KTableImpl<K, ?, V1> table1, KTableImpl<K, ?, V2> table2, ValueJoiner<? super V1, ? super V2, ? extends VOut> joiner) {
        super(table1, table2, joiner);
    }

    @Override
    public Processor<K, Change<V1>, K, Change<VOut>> get() {
        return new KTableKTableLeftJoinProcessor(this.valueGetterSupplier2.get());
    }

    @Override
    public KTableValueGetterSupplier<K, VOut> view() {
        return new KTableKTableLeftJoinValueGetterSupplier(this.valueGetterSupplier1, this.valueGetterSupplier2);
    }

    private class KTableKTableLeftJoinProcessor
    extends ContextualProcessor<K, Change<V1>, K, Change<VOut>> {
        private final KTableValueGetter<K, V2> valueGetter;
        private Sensor droppedRecordsSensor;

        KTableKTableLeftJoinProcessor(KTableValueGetter<K, V2> valueGetter) {
            this.valueGetter = valueGetter;
        }

        @Override
        public void init(ProcessorContext<K, Change<VOut>> context) {
            super.init(context);
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(Thread.currentThread().getName(), context.taskId().toString(), (StreamsMetricsImpl)context.metrics());
            this.valueGetter.init(context);
        }

        @Override
        public void process(Record<K, Change<V1>> record) {
            long timestampRight;
            if (record.key() == null) {
                if (this.context().recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = this.context().recordMetadata().get();
                    LOG.warn("Skipping record due to null key. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                } else {
                    LOG.warn("Skipping record due to null key. Topic, partition, and offset not known.");
                }
                this.droppedRecordsSensor.record();
                return;
            }
            if (KTableKTableLeftJoin.this.useVersionedSemantics && !record.value().isLatest) {
                LOG.info("Skipping out-of-order record from versioned table while performing table-table join.");
                this.droppedRecordsSensor.record();
                return;
            }
            Object newValue = null;
            Object oldValue = null;
            ValueAndTimestamp valueAndTimestampRight = this.valueGetter.get(record.key());
            Object value2 = ValueAndTimestamp.getValueOrNull(valueAndTimestampRight);
            if (value2 == null) {
                if (record.value().newValue == null && record.value().oldValue == null) {
                    return;
                }
                timestampRight = -1L;
            } else {
                timestampRight = valueAndTimestampRight.timestamp();
            }
            long resultTimestamp = Math.max(record.timestamp(), timestampRight);
            if (record.value().newValue != null) {
                newValue = KTableKTableLeftJoin.this.joiner.apply(record.value().newValue, value2);
            }
            if (KTableKTableLeftJoin.this.sendOldValues && record.value().oldValue != null) {
                oldValue = KTableKTableLeftJoin.this.joiner.apply(record.value().oldValue, value2);
            }
            this.context().forward(record.withValue(new Change<Object>(newValue, oldValue, record.value().isLatest)).withTimestamp(resultTimestamp));
        }

        @Override
        public void close() {
            this.valueGetter.close();
        }
    }

    private class KTableKTableLeftJoinValueGetterSupplier
    extends KTableKTableAbstractJoinValueGetterSupplier<K, VOut, V1, V2> {
        KTableKTableLeftJoinValueGetterSupplier(KTableValueGetterSupplier<K, V1> valueGetterSupplier1, KTableValueGetterSupplier<K, V2> valueGetterSupplier2) {
            super(valueGetterSupplier1, valueGetterSupplier2);
        }

        @Override
        public KTableValueGetter<K, VOut> get() {
            return new KTableKTableLeftJoinValueGetter(this.valueGetterSupplier1.get(), this.valueGetterSupplier2.get());
        }
    }

    private class KTableKTableLeftJoinValueGetter
    implements KTableValueGetter<K, VOut> {
        private final KTableValueGetter<K, V1> valueGetter1;
        private final KTableValueGetter<K, V2> valueGetter2;

        KTableKTableLeftJoinValueGetter(KTableValueGetter<K, V1> valueGetter1, KTableValueGetter<K, V2> valueGetter2) {
            this.valueGetter1 = valueGetter1;
            this.valueGetter2 = valueGetter2;
        }

        @Override
        public void init(ProcessorContext<?, ?> context) {
            this.valueGetter1.init(context);
            this.valueGetter2.init(context);
        }

        @Override
        public ValueAndTimestamp<VOut> get(K key) {
            ValueAndTimestamp valueAndTimestamp1 = this.valueGetter1.get(key);
            Object value1 = ValueAndTimestamp.getValueOrNull(valueAndTimestamp1);
            if (value1 != null) {
                ValueAndTimestamp valueAndTimestamp2 = this.valueGetter2.get(key);
                Object value2 = ValueAndTimestamp.getValueOrNull(valueAndTimestamp2);
                long resultTimestamp = valueAndTimestamp2 == null ? valueAndTimestamp1.timestamp() : Math.max(valueAndTimestamp1.timestamp(), valueAndTimestamp2.timestamp());
                return ValueAndTimestamp.make(KTableKTableLeftJoin.this.joiner.apply(value1, value2), resultTimestamp);
            }
            return null;
        }

        @Override
        public boolean isVersioned() {
            return false;
        }

        @Override
        public void close() {
            this.valueGetter1.close();
            this.valueGetter2.close();
        }
    }
}

