/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.sf.juife.NavigationPage;
import org.jsampler.CC;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.event.ListEvent;
import org.jsampler.event.ListListener;
import org.jsampler.event.MidiInstrumentMapEvent;
import org.jsampler.event.MidiInstrumentMapListener;
import org.jsampler.view.classic.A4n;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.RemoveMidiInstrumentMapDlg;
import org.jsampler.view.classic.Res;
import org.jsampler.view.classic.ToolbarButton;
import org.jsampler.view.std.JSAddMidiInstrumentMapDlg;
import org.jsampler.view.std.JSMidiInstrumentsPane;

public class MidiInstrumentMapsPage
extends NavigationPage {
    private final JToolBar tbMaps = new JToolBar();
    private final EditMap actionEditMap = new EditMap();
    private final RemoveMap actionRemoveMap = new RemoveMap();
    private final ToolbarButton btnAddMap = new ToolbarButton(A4n.addMidiInstrumentMap);
    private final ToolbarButton btnEditMap = new ToolbarButton(this.actionEditMap);
    private final ToolbarButton btnRemoveMap = new ToolbarButton(this.actionRemoveMap);
    private final ToolbarButton btnExportMaps;
    private final JComboBox cbMaps;
    private final MidiInstrumentsPane midiInstrumentsPane;
    private final Handler handler;

    public MidiInstrumentMapsPage() {
        this.btnExportMaps = new ToolbarButton(A4n.a4n.exportMidiInstrumentMaps);
        this.cbMaps = new JComboBox();
        this.midiInstrumentsPane = new MidiInstrumentsPane();
        this.handler = new Handler();
        this.setTitle(ClassicI18n.i18n.getLabel("MidiInstrumentMapsPage.title"));
        this.setLayout(new BoxLayout(this, 1));
        this.tbMaps.add(this.btnAddMap);
        this.tbMaps.add(this.btnEditMap);
        this.tbMaps.add(this.btnRemoveMap);
        this.tbMaps.addSeparator();
        this.tbMaps.add(this.btnExportMaps);
        Dimension dimension = new Dimension(Short.MAX_VALUE, this.tbMaps.getPreferredSize().height);
        this.tbMaps.setMaximumSize(dimension);
        this.tbMaps.setFloatable(false);
        this.tbMaps.setAlignmentX(0.0f);
        this.add(this.tbMaps);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.0f);
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.cbMaps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MidiInstrumentMapsPage.this.mapChanged();
            }
        });
        for (MidiInstrumentMap midiInstrumentMap : CC.getSamplerModel().getMidiInstrumentMaps()) {
            this.cbMaps.addItem(midiInstrumentMap);
            midiInstrumentMap.addMidiInstrumentMapListener(this.getHandler());
        }
        this.cbMaps.setEnabled(this.cbMaps.getItemCount() > 0);
        dimension = new Dimension(Short.MAX_VALUE, this.cbMaps.getPreferredSize().height);
        this.cbMaps.setMaximumSize(dimension);
        CC.getSamplerModel().addMidiInstrumentMapListListener(this.getHandler());
        jPanel.add(this.cbMaps);
        jPanel.add(Box.createRigidArea(new Dimension(0, 12)));
        this.add(jPanel);
        this.add(this.midiInstrumentsPane);
        boolean bl = this.cbMaps.getItemCount() != 0;
        this.actionEditMap.setEnabled(bl);
        this.actionRemoveMap.setEnabled(bl);
        A4n.removeMidiInstrumentMap.setEnabled(bl);
        A4n.addMidiInstrumentWizard.setEnabled(bl);
    }

    private void mapChanged() {
        MidiInstrumentMap midiInstrumentMap = (MidiInstrumentMap)this.cbMaps.getSelectedItem();
        this.midiInstrumentsPane.setMidiInstrumentMap(midiInstrumentMap);
        boolean bl = this.cbMaps.getItemCount() != 0;
        this.actionEditMap.setEnabled(bl);
        this.actionRemoveMap.setEnabled(bl);
        A4n.removeMidiInstrumentMap.setEnabled(bl);
        A4n.addMidiInstrumentWizard.setEnabled(bl);
    }

    private Handler getHandler() {
        return this.handler;
    }

    private class Handler
    implements ListListener<MidiInstrumentMap>,
    MidiInstrumentMapListener {
        private Handler() {
        }

        @Override
        public void entryAdded(ListEvent<MidiInstrumentMap> listEvent) {
            MidiInstrumentMap midiInstrumentMap = listEvent.getEntry();
            if (MidiInstrumentMapsPage.this.cbMaps.getItemCount() == 0) {
                MidiInstrumentMapsPage.this.cbMaps.setEnabled(true);
            }
            MidiInstrumentMapsPage.this.cbMaps.addItem(midiInstrumentMap);
            MidiInstrumentMapsPage.this.cbMaps.setSelectedItem(midiInstrumentMap);
            midiInstrumentMap.addMidiInstrumentMapListener(MidiInstrumentMapsPage.this.getHandler());
        }

        @Override
        public void entryRemoved(ListEvent<MidiInstrumentMap> listEvent) {
            MidiInstrumentMapsPage.this.cbMaps.removeItem(listEvent.getEntry());
            if (MidiInstrumentMapsPage.this.cbMaps.getItemCount() == 0) {
                MidiInstrumentMapsPage.this.cbMaps.setEnabled(false);
            }
            listEvent.getEntry().removeMidiInstrumentMapListener(MidiInstrumentMapsPage.this.getHandler());
        }

        @Override
        public void nameChanged(MidiInstrumentMapEvent midiInstrumentMapEvent) {
            MidiInstrumentMapsPage.this.cbMaps.repaint();
        }

        @Override
        public void instrumentAdded(MidiInstrumentMapEvent midiInstrumentMapEvent) {
        }

        @Override
        public void instrumentRemoved(MidiInstrumentMapEvent midiInstrumentMapEvent) {
        }
    }

    private class RemoveMap
    extends AbstractAction {
        RemoveMap() {
            super(ClassicI18n.i18n.getMenuLabel("actions.midiInstruments.removeMap"));
            String string = ClassicI18n.i18n.getMenuLabel("actions.midiInstruments.removeMap.tt");
            this.putValue("ShortDescription", string);
            this.putValue("SmallIcon", Res.iconDelete16);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MidiInstrumentMap midiInstrumentMap = (MidiInstrumentMap)MidiInstrumentMapsPage.this.cbMaps.getSelectedItem();
            RemoveMidiInstrumentMapDlg removeMidiInstrumentMapDlg = new RemoveMidiInstrumentMapDlg(midiInstrumentMap);
            removeMidiInstrumentMapDlg.setVisible(true);
            if (removeMidiInstrumentMapDlg.isCancelled()) {
                return;
            }
            int n = removeMidiInstrumentMapDlg.getSelectedMap().getMapId();
            CC.getSamplerModel().removeBackendMidiInstrumentMap(n);
        }
    }

    private class EditMap
    extends AbstractAction {
        EditMap() {
            super(ClassicI18n.i18n.getLabel("MidiInstrumentMapsPage.editMap"));
            String string = ClassicI18n.i18n.getLabel("MidiInstrumentMapsPage.editMap.tt");
            this.putValue("ShortDescription", string);
            this.putValue("SmallIcon", Res.iconEdit16);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MidiInstrumentMap midiInstrumentMap = (MidiInstrumentMap)MidiInstrumentMapsPage.this.cbMaps.getSelectedItem();
            int n = midiInstrumentMap.getMapId();
            JSAddMidiInstrumentMapDlg jSAddMidiInstrumentMapDlg = new JSAddMidiInstrumentMapDlg();
            jSAddMidiInstrumentMapDlg.setTitle(ClassicI18n.i18n.getLabel("MidiInstrumentMapsPage.editMap"));
            jSAddMidiInstrumentMapDlg.setMapName(midiInstrumentMap.getName());
            jSAddMidiInstrumentMapDlg.setVisible(true);
            if (jSAddMidiInstrumentMapDlg.isCancelled()) {
                return;
            }
            midiInstrumentMap.setName(jSAddMidiInstrumentMapDlg.getMapName());
            CC.getSamplerModel().setBackendMidiInstrumentMapName(n, jSAddMidiInstrumentMapDlg.getMapName());
        }
    }

    class MidiInstrumentsPane
    extends JSMidiInstrumentsPane {
        private final JToolBar tbInstruments = new JToolBar();
        private final ToolbarButton btnAddInstrument = new ToolbarButton(A4n.addMidiInstrumentWizard);
        private final ToolbarButton btnEditInstrument = new ToolbarButton(this.actionEditInstrument);
        private final ToolbarButton btnRemoveInstrument = new ToolbarButton(this.actionRemove);

        MidiInstrumentsPane() {
            this.actionEditInstrument.putValue("SmallIcon", Res.iconEdit16);
            this.actionRemove.putValue("SmallIcon", Res.iconDelete16);
            this.removeAll();
            this.tbInstruments.add(this.btnAddInstrument);
            this.tbInstruments.add(this.btnEditInstrument);
            this.tbInstruments.add(this.btnRemoveInstrument);
            Dimension dimension = new Dimension(Short.MAX_VALUE, this.tbInstruments.getPreferredSize().height);
            this.tbInstruments.setMaximumSize(dimension);
            this.tbInstruments.setFloatable(false);
            this.add((Component)this.tbInstruments, "North");
            JScrollPane jScrollPane = new JScrollPane(this.midiInstrumentTree);
            DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
            defaultTreeCellRenderer.setClosedIcon(Res.iconFolder16);
            defaultTreeCellRenderer.setOpenIcon(Res.iconFolderOpen16);
            defaultTreeCellRenderer.setLeafIcon(Res.iconInstrument16);
            this.midiInstrumentTree.setCellRenderer(defaultTreeCellRenderer);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            jPanel.add(jScrollPane);
            this.add(jPanel);
            this.setAlignmentX(0.0f);
        }
    }
}

