// Generated by gmmproc 2.86.0 -- DO NOT MODIFY!
#ifndef _GIOMM_SUBPROCESSLAUNCHER_H
#define _GIOMM_SUBPROCESSLAUNCHER_H

#include <giommconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2023 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/object.h>
#include <glibmm/spawn.h>
#include <giomm/subprocess.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GSubprocessLauncher = struct _GSubprocessLauncher;
using GSubprocessLauncherClass = struct _GSubprocessLauncherClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gio
{ class GIOMM_API SubprocessLauncher_Class; } // namespace Gio
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gio
{

/** Environment options for launching a child process.
 *
 * This class contains a set of options for launching child processes,
 * such as where its standard input and output will be directed, the
 * argument list, the environment, and more.
 *
 * While the Gio::Subprocess class has high level functions covering
 * popular cases, use of this class allows access to more advanced
 * options. It can also be used to launch multiple subprocesses with
 * a similar configuration.
 *
 * @see Subprocess
 * @newin{2,78}
 */

class GIOMM_API SubprocessLauncher : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = SubprocessLauncher;
  using CppClassType = SubprocessLauncher_Class;
  using BaseObjectType = GSubprocessLauncher;
  using BaseClassType = GSubprocessLauncherClass;

  // noncopyable
  SubprocessLauncher(const SubprocessLauncher&) = delete;
  SubprocessLauncher& operator=(const SubprocessLauncher&) = delete;

private:  friend class SubprocessLauncher_Class;
  static CppClassType subprocesslauncher_class_;

protected:
  explicit SubprocessLauncher(const Glib::ConstructParams& construct_params);
  explicit SubprocessLauncher(GSubprocessLauncher* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  SubprocessLauncher(SubprocessLauncher&& src) noexcept;
  SubprocessLauncher& operator=(SubprocessLauncher&& src) noexcept;

  ~SubprocessLauncher() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GSubprocessLauncher*       gobj()       { return reinterpret_cast<GSubprocessLauncher*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GSubprocessLauncher* gobj() const { return reinterpret_cast<GSubprocessLauncher*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GSubprocessLauncher* gobj_copy();

private:


public:
  // g_subprocess_launcher_new() does more than call g_object_new().
  
  /** Creates a new SubprocessLauncher.
   * 
   * The launcher is created with the default options.  A copy of the
   * environment of the calling process is made at the time of this call
   * and will be used as the environment that the process is launched in.
   * 
   * @newin{2,78}
   * 
   * @param flags SubprocessFlags.
   */
  static Glib::RefPtr<SubprocessLauncher> create(Subprocess::Flags flags =  Subprocess::Flags::NONE);

 
  /** Creates a Subprocess given a provided array of arguments.
   * 
   * @newin{2,78}
   * 
   * @param argv Command line arguments.
   * @return A new Subprocess, or <tt>nullptr</tt> on error (and @a error will be set).
   * 
   * @throws Glib::Error
   */
  Glib::RefPtr<Subprocess> spawn(const std::vector<std::string>& argv);
  

  /** Inherit the parent process’ environment.
   * @newin{2,78}
   */
  void inherit_environ();
 

  /** Replace the entire environment of processes launched from this
   * launcher with the given 'environ' variable.
   * 
   * Typically you will build this variable by using Glib::listenv() to copy
   * the process 'environ' and using the functions Glib::environ_setenv(),
   * Glib::environ_unsetenv(), etc.
   * 
   * As an alternative, you can use g_subprocess_launcher_setenv(),
   * g_subprocess_launcher_unsetenv(), etc.
   * 
   * Pass an empty array to set an empty environment. Pass <tt>nullptr</tt> to inherit the
   * parent process’ environment. As of GLib 2.54, the parent process’ environment
   * will be copied when g_subprocess_launcher_set_environ() is called.
   * Previously, it was copied when the subprocess was executed. This means the
   * copied environment may now be modified (using g_subprocess_launcher_setenv(),
   * etc.) before launching the subprocess.
   * 
   * On UNIX, all strings in this array can be arbitrary byte strings.
   * On Windows, they should be in UTF-8.
   * 
   * @newin{2,78}
   * 
   * @param env The replacement environment.
   */
  void set_environ(const std::vector<std::string>& env);
  
  /** Sets the environment variable @a variable in the environment of
   * processes launched from this launcher.
   * 
   * On UNIX, both the variable's name and value can be arbitrary byte
   * strings, except that the variable's name cannot contain '='.
   * On Windows, they should be in UTF-8.
   * 
   * @newin{2,78}
   * 
   * @param variable The environment variable to set,
   * must not contain '='.
   * @param value The new value for the variable.
   * @param overwrite Whether to change the variable if it already exists.
   */
  void setenv(const std::string& variable, const std::string& value, bool overwrite);
  
  /** Removes the environment variable @a variable from the environment of
   * processes launched from this launcher.
   * 
   * On UNIX, the variable's name can be an arbitrary byte string not
   * containing '='. On Windows, it should be in UTF-8.
   * 
   * @newin{2,78}
   * 
   * @param variable The environment variable to unset,
   * must not contain '='.
   */
  void unsetenv(const std::string& variable);
  
  /** Returns the value of the environment variable @a variable in the
   * environment of processes launched from this launcher.
   * 
   * On UNIX, the returned string can be an arbitrary byte string.
   * On Windows, it will be UTF-8.
   * 
   * @newin{2,78}
   * 
   * @param variable The environment variable to get.
   * @return The value of the environment variable,
   * <tt>nullptr</tt> if unset.
   */
  std::string getenv(const std::string& variable);

  
  /** Sets the current working directory that processes will be launched
   * with.
   * 
   * By default processes are launched with the current working directory
   * of the launching process at the time of launch.
   * 
   * @newin{2,78}
   * 
   * @param cwd The cwd for launched processes.
   */
  void set_cwd(const std::string& cwd);
  
  /** Sets the flags on the launcher.
   * 
   * The default flags are Gio::Subprocess::Flags::NONE.
   * 
   * You may not set flags that specify conflicting options for how to
   * handle a particular stdio stream (eg: specifying both
   * Gio::Subprocess::Flags::STDIN_PIPE and
   * Gio::Subprocess::Flags::STDIN_INHERIT).
   * 
   * You may also not set a flag that conflicts with a previous call to a
   * function like g_subprocess_launcher_set_stdin_file_path() or
   * g_subprocess_launcher_take_stdout_fd().
   * 
   * @newin{2,78}
   * 
   * @param flags SubprocessFlags.
   */
  void set_flags(Subprocess::Flags flags);

  // Extended I/O control, only available on UNIX.
  
#ifdef  G_OS_UNIX

  /** Sets the file path to use as the stdin for spawned processes.
   * 
   * If @a path is <tt>nullptr</tt> then any previously given path is unset.
   * 
   * The file must exist or spawning the process will fail.
   * 
   * You may not set a stdin file path if a stdin fd is already set or if
   * the launcher flags contain any flags directing stdin elsewhere.
   * 
   * This feature is only available on UNIX.
   * 
   * @newin{2,78}
   * 
   * @param path A filename or <tt>nullptr</tt>.
   */
  void set_stdin_file_path(const std::string& path);
#endif //  G_OS_UNIX

  
#ifdef  G_OS_UNIX

  /** Sets the file descriptor to use as the stdin for spawned processes.
   * 
   * If @a fd is -1 then any previously given fd is unset.
   * 
   * Note that if your intention is to have the stdin of the calling
   * process inherited by the child then Gio::Subprocess::Flags::STDIN_INHERIT
   * is a better way to go about doing that.
   * 
   * The passed @a fd is noted but will not be touched in the current
   * process.  It is therefore necessary that it be kept open by the
   * caller until the subprocess is spawned.  The file descriptor will
   * also not be explicitly closed on the child side, so it must be marked
   * O_CLOEXEC if that's what you want.
   * 
   * You may not set a stdin fd if a stdin file path is already set or if
   * the launcher flags contain any flags directing stdin elsewhere.
   * 
   * This feature is only available on UNIX.
   * 
   * @newin{2,78}
   * 
   * @param fd A file descriptor, or -1.
   */
  void take_stdin_fd(int fd);
#endif //  G_OS_UNIX


#ifdef  G_OS_UNIX

  /** Sets the file path to use as the stdout for spawned processes.
   * 
   * If @a path is <tt>nullptr</tt> then any previously given path is unset.
   * 
   * The file will be created or truncated when the process is spawned, as
   * would be the case if using '>' at the shell.
   * 
   * You may not set a stdout file path if a stdout fd is already set or
   * if the launcher flags contain any flags directing stdout elsewhere.
   * 
   * This feature is only available on UNIX.
   * 
   * @newin{2,78}
   * 
   * @param path A filename or <tt>nullptr</tt>.
   */
  void set_stdout_file_path(const std::string& path);
#endif //  G_OS_UNIX

  
#ifdef  G_OS_UNIX

  /** Sets the file descriptor to use as the stdout for spawned processes.
   * 
   * If @a fd is -1 then any previously given fd is unset.
   * 
   * Note that the default behaviour is to pass stdout through to the
   * stdout of the parent process.
   * 
   * The passed @a fd is noted but will not be touched in the current
   * process.  It is therefore necessary that it be kept open by the
   * caller until the subprocess is spawned.  The file descriptor will
   * also not be explicitly closed on the child side, so it must be marked
   * O_CLOEXEC if that's what you want.
   * 
   * You may not set a stdout fd if a stdout file path is already set or
   * if the launcher flags contain any flags directing stdout elsewhere.
   * 
   * This feature is only available on UNIX.
   * 
   * @newin{2,78}
   * 
   * @param fd A file descriptor, or -1.
   */
  void take_stdout_fd(int fd);
#endif //  G_OS_UNIX


#ifdef  G_OS_UNIX

  /** Sets the file path to use as the stderr for spawned processes.
   * 
   * If @a path is <tt>nullptr</tt> then any previously given path is unset.
   * 
   * The file will be created or truncated when the process is spawned, as
   * would be the case if using '2>' at the shell.
   * 
   * If you want to send both stdout and stderr to the same file then use
   * Gio::Subprocess::Flags::STDERR_MERGE.
   * 
   * You may not set a stderr file path if a stderr fd is already set or
   * if the launcher flags contain any flags directing stderr elsewhere.
   * 
   * This feature is only available on UNIX.
   * 
   * @newin{2,78}
   * 
   * @param path A filename or <tt>nullptr</tt>.
   */
  void set_stderr_file_path(const std::string& path);
#endif //  G_OS_UNIX

  
#ifdef  G_OS_UNIX

  /** Sets the file descriptor to use as the stderr for spawned processes.
   * 
   * If @a fd is -1 then any previously given fd is unset.
   * 
   * Note that the default behaviour is to pass stderr through to the
   * stderr of the parent process.
   * 
   * The passed @a fd belongs to the SubprocessLauncher.  It will be
   * automatically closed when the launcher is finalized.  The file
   * descriptor will also be closed on the child side when executing the
   * spawned process.
   * 
   * You may not set a stderr fd if a stderr file path is already set or
   * if the launcher flags contain any flags directing stderr elsewhere.
   * 
   * This feature is only available on UNIX.
   * 
   * @newin{2,78}
   * 
   * @param fd A file descriptor, or -1.
   */
  void take_stderr_fd(int fd);
#endif //  G_OS_UNIX


#ifdef  G_OS_UNIX

  /** Transfer an arbitrary file descriptor from parent process to the
   * child.  This function takes ownership of the @a source_fd; it will be closed
   * in the parent when @a self is freed.
   * 
   * By default, all file descriptors from the parent will be closed.
   * This function allows you to create (for example) a custom `pipe()` or
   * `socketpair()` before launching the process, and choose the target
   * descriptor in the child.
   * 
   * An example use case is GNUPG, which has a command line argument
   * `--passphrase-fd` providing a file descriptor number where it expects
   * the passphrase to be written.
   * 
   * @newin{2,78}
   * 
   * @param source_fd File descriptor in parent process.
   * @param target_fd Target descriptor for child process.
   */
  void take_fd(int source_fd, int target_fd);
#endif //  G_OS_UNIX


#ifdef  G_OS_UNIX

  /** Closes all the file descriptors previously passed to the object with
   * g_subprocess_launcher_take_fd(), g_subprocess_launcher_take_stderr_fd(), etc.
   * 
   * After calling this method, any subsequent calls to g_subprocess_launcher_spawn() or g_subprocess_launcher_spawnv() will
   * return Gio::Error::CLOSED. This method is idempotent if
   * called more than once.
   * 
   * This function is called automatically when the SubprocessLauncher
   * is disposed, but is provided separately so that garbage collected
   * language bindings can call it earlier to guarantee when FDs are closed.
   * 
   * @newin{2,78}
   */
  void close();
#endif //  G_OS_UNIX


#ifdef G_OS_UNIX
  /** Sets up a child setup function.
   *
   * The child setup function will be called after fork() but before
   * exec() on the child's side.
   *
   * A copy of the @a child_setup slot is stored. The copy will not be
   * automatically deleted on the child's side of the fork(). It will only be
   * deleted when the last reference on the %SubprocessLauncher is dropped
   * or when a new child setup slot is given.
   *
   * An empty slot can be given as @a child_setup to disable the functionality.
   *
   * Child setup functions are only available on UNIX.
   *
   * @newin{2,78}
   *
   * @param child_setup A Glib::SlotSpawnChildSetup to use as the child setup function.
   */
  void set_child_setup(const Glib::SlotSpawnChildSetup& child_setup = {});
  
#endif // G_OS_UNIX

  // _IGNORE_PROPERTY("flags") // write-only, construct-only


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::SubprocessLauncher
   */
  GIOMM_API
  Glib::RefPtr<Gio::SubprocessLauncher> wrap(GSubprocessLauncher* object, bool take_copy = false);
}


#endif /* _GIOMM_SUBPROCESSLAUNCHER_H */

