/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.clipboard;

import java.util.SortedSet;
import java.util.TreeSet;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.clipboard.CopyAction;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class ClipboardControllers
implements IExtension {
    private final SortedSet<ClipboardController> controllers = new TreeSet<ClipboardController>(this::prioritySort);
    public final CopyAction copyAction;

    public static void install(ClipboardControllers clipboardController) {
        Controller.getCurrentModeController().addExtension(ClipboardControllers.class, clipboardController);
    }

    public static ClipboardControllers getController() {
        return Controller.getCurrentModeController().getExtension(ClipboardControllers.class);
    }

    public ClipboardControllers() {
        Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController();
        this.copyAction = new CopyAction();
        modeController.addAction(this.copyAction);
    }

    protected int prioritySort(ClipboardController x, ClipboardController y) {
        return -Integer.compare(x.getPriority(), y.getPriority());
    }

    public boolean add(ClipboardController e) {
        return this.controllers.add(e);
    }

    public void copy() {
        this.controllers.stream().filter(ClipboardController::canCopy).findFirst().ifPresent(ClipboardController::copy);
    }
}

