/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.copilot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.annotations.SerializedName;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.Future;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseChunk;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseConsumer;
import org.jkiss.dbeaver.model.ai.engine.AbstractHttpAIClient;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotChatChunk;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotChatRequest;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotChatResponse;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotModel;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotModelList;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotSessionToken;
import org.jkiss.dbeaver.model.ai.utils.AIHttpUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class CopilotClient
extends AbstractHttpAIClient {
    private static final Log log = Log.getLog(CopilotClient.class);
    private static final String DATA_EVENT = "data: ";
    private static final String DONE_EVENT = "[DONE]";
    protected static final Duration TIMEOUT = Duration.ofSeconds(30L);
    protected static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).serializeNulls().create();
    private static final String EDITOR_VERSION = "Neovim/0.6.1";
    private static final String EDITOR_PLUGIN_VERSION = "copilot.vim/1.16.0";
    private static final String USER_AGENT = "GithubCopilot/1.155.0";
    protected static final String CHAT_EDITOR_VERSION = "vscode/1.80.1";
    private static final String DBEAVER_OAUTH_APP = "Iv1.b507a08c87ecfe98";
    private static final String COPILOT_CHAT_MODELS_URL = "https://api.githubcopilot.com/models";
    private static final String CHAT_REQUEST_URL = "https://api.githubcopilot.com/chat/completions";
    private static final String COPILOT_SESSION_TOKEN_URL = "/copilot_internal/v2/token";
    private final String baseAuthURL;

    public CopilotClient(@NotNull String authProviderBaseURL) {
        this.baseAuthURL = authProviderBaseURL;
    }

    public DeviceCodeResponse requestDeviceCode(@NotNull DBRProgressMonitor monitor) throws DBException {
        DeviceCodeRequest deviceCodeRequest = new DeviceCodeRequest(DBEAVER_OAUTH_APP, "read:user");
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve("https://github.com/login/device/code", new String[0])).header("accept", "application/json").header("content-type", "application/json").timeout(Duration.ofSeconds(10L)).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)deviceCodeRequest))).build();
        return (DeviceCodeResponse)GSON.fromJson(this.client.send(monitor, request), DeviceCodeResponse.class);
    }

    @NotNull
    public String requestAccessToken(@NotNull DBRProgressMonitor monitor, @NotNull DeviceCodeResponse deviceCodeResponse, @NotNull Future<?> cancellationToken) throws DBException, InterruptedException {
        AccessTokenRequest accessTokenRequest = new AccessTokenRequest(DBEAVER_OAUTH_APP, deviceCodeResponse.deviceCode(), "urn:ietf:params:oauth:grant-type:device_code");
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve("https://github.com/login/oauth/access_token", new String[0])).header("accept", "application/json").header("content-type", "application/json").timeout(Duration.ofSeconds(5L)).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)accessTokenRequest))).build();
        Duration expiresIn = Duration.ofSeconds(deviceCodeResponse.expiresIn());
        Duration interval = Duration.ofSeconds(deviceCodeResponse.interval());
        Instant start = Instant.now();
        block8: while (Instant.now().isBefore(start.plus(expiresIn)) && !monitor.isCanceled() && !cancellationToken.isCancelled()) {
            AccessTokenResponse body = (AccessTokenResponse)GSON.fromJson(this.client.send(monitor, request), AccessTokenResponse.class);
            if (CommonUtils.isNotEmpty((String)body.accessToken())) {
                return body.accessToken();
            }
            switch (body.error()) {
                case "authorization_pending": {
                    Thread.sleep(interval.toMillis());
                    continue block8;
                }
                case "slow_down": {
                    Thread.sleep(interval.plusSeconds(5L).toMillis());
                    continue block8;
                }
            }
            throw new DBException("Error requesting access token: " + body.error());
        }
        if (monitor.isCanceled() || cancellationToken.isCancelled()) {
            throw new DBException("Access token request was canceled by the user");
        }
        throw new DBException("Access token request timed out");
    }

    @NotNull
    public CopilotSessionToken requestSessionToken(DBRProgressMonitor monitor, String accessToken) throws DBException {
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve(this.baseAuthURL + COPILOT_SESSION_TOKEN_URL, new String[0])).header("authorization", "token " + accessToken).header("editor-version", EDITOR_VERSION).header("editor-plugin-version", EDITOR_PLUGIN_VERSION).header("User-Agent", USER_AGENT).GET().timeout(TIMEOUT).build();
        return (CopilotSessionToken)GSON.fromJson(this.client.send(monitor, request), CopilotSessionToken.class);
    }

    public CopilotChatResponse chat(DBRProgressMonitor monitor, String token, CopilotChatRequest chatRequest) throws DBException {
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve(CHAT_REQUEST_URL, new String[0])).header("Content-type", "application/json").header("authorization", "Bearer " + token).header("Editor-Version", CHAT_EDITOR_VERSION).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)chatRequest))).timeout(TIMEOUT).build();
        String responseJson = this.client.send(monitor, request);
        return (CopilotChatResponse)GSON.fromJson(responseJson, CopilotChatResponse.class);
    }

    public void createChatCompletionStream(@NotNull DBRProgressMonitor monitor, @NotNull String token, @NotNull CopilotChatRequest chatRequest, @NotNull AIEngineResponseConsumer listener) throws DBException {
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve(CHAT_REQUEST_URL, new String[0])).header("Content-type", "application/json").header("authorization", "Bearer " + token).header("Editor-Version", CHAT_EDITOR_VERSION).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)chatRequest))).timeout(TIMEOUT).build();
        this.client.sendAsync(request, line -> {
            if (line.startsWith(DATA_EVENT)) {
                String data = line.substring(6).trim();
                if (data.equals(DONE_EVENT)) {
                    listener.completeBlock();
                    return;
                }
                try {
                    CopilotChatChunk chunk = (CopilotChatChunk)GSON.fromJson(data, CopilotChatChunk.class);
                    List<String> choices = chunk.choices().stream().takeWhile(it -> it.delta().content() != null).map(it -> it.delta().content()).toList();
                    listener.nextChunk(new AIEngineResponseChunk(choices));
                    listener.usage(chunk.getAIUsage());
                }
                catch (Exception e) {
                    listener.error(e);
                }
            }
        }, listener::error, listener::completeBlock);
    }

    @Override
    @NotNull
    protected DBException mapHttpError(int statusCode, @NotNull String body) {
        log.debug((Object)("Copilot request failed: " + statusCode + ", " + body));
        return new DBException("Copilot request failed: " + AIHttpUtils.parseOpenAIStyleErrorMessage(body));
    }

    public List<CopilotModel> loadModels(@NotNull DBRProgressMonitor monitor, @NotNull String token) throws DBException {
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve(COPILOT_CHAT_MODELS_URL, new String[0])).header("Content-type", "application/json").header("authorization", "Bearer " + token).header("Editor-Version", CHAT_EDITOR_VERSION).GET().timeout(TIMEOUT).build();
        String response = this.client.send(monitor, request);
        CopilotModelList models = (CopilotModelList)GSON.fromJson(response, CopilotModelList.class);
        return models.data().stream().filter(CopilotModel::isEnabled).toList();
    }

    private record DeviceCodeRequest(@SerializedName(value="client_id") String clientId, @SerializedName(value="scope") String scope) {
    }

    public record DeviceCodeResponse(@SerializedName(value="device_code") String deviceCode, @SerializedName(value="user_code") String userCode, @SerializedName(value="verification_uri") String verificationUri, @SerializedName(value="expires_in") int expiresIn, @SerializedName(value="interval") int interval) {
    }

    private record AccessTokenRequest(@SerializedName(value="client_id") String clientId, @SerializedName(value="device_code") String deviceCode, @SerializedName(value="grant_type") String grantType) {
    }

    private record AccessTokenResponse(@SerializedName(value="error") String error, @SerializedName(value="access_token") String accessToken) {
    }
}

