/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;

public class ArrayUtils {
    public static boolean isEmpty(@Nullable Object[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean isEmpty(@Nullable short[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isArray(@Nullable Object value) {
        return value != null && value.getClass().isArray();
    }

    public static boolean contains(@Nullable short[] array, short value) {
        if (array == null) {
            return false;
        }
        for (short item : array) {
            if (item != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(@Nullable char[] array, char value) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (char c : array) {
            if (c != value) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(@Nullable int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean contains(@Nullable int[] array, int value) {
        if (array == null) {
            return false;
        }
        for (int v : array) {
            if (v != value) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(@Nullable long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean contains(@Nullable long[] array, long value) {
        if (array == null) {
            return false;
        }
        for (long v : array) {
            if (v != value) continue;
            return true;
        }
        return false;
    }

    public static <OBJECT_TYPE> boolean contains(OBJECT_TYPE[] array, OBJECT_TYPE value) {
        if (ArrayUtils.isEmpty(array)) {
            return false;
        }
        for (OBJECT_TYPE object_type : array) {
            if (!CommonUtils.equalObjects(value, object_type)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String[] array, String value) {
        if (ArrayUtils.isEmpty(array) || value == null) {
            return false;
        }
        for (String s : array) {
            if (!value.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static <OBJECT_TYPE> boolean containsRef(@NotNull OBJECT_TYPE[] array, @Nullable OBJECT_TYPE value) {
        int length = array.length;
        for (OBJECT_TYPE object_type : array) {
            if (value != object_type) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <OBJECT_TYPE> boolean containsAny(OBJECT_TYPE[] array, OBJECT_TYPE ... values) {
        for (OBJECT_TYPE item : array) {
            for (OBJECT_TYPE value : values) {
                if (!CommonUtils.equalObjects(item, value)) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    public static <OBJECT_TYPE> boolean containsAll(OBJECT_TYPE[] array, OBJECT_TYPE ... values) {
        if (ArrayUtils.isEmpty(array)) {
            return false;
        }
        for (OBJECT_TYPE value : values) {
            if (ArrayUtils.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static <T> T[] concatArrays(@NotNull T[] first, @NotNull T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    @NotNull
    public static <T> List<T> safeArray(@Nullable T[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    public static <T> int indexOf(@NotNull T[] array, @NotNull Predicate<T> condition) {
        for (int i = 0; i < array.length; ++i) {
            if (!condition.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] array, T element) {
        for (int i = 0; i < array.length; ++i) {
            if (!CommonUtils.equalObjects(array[i], element)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int offset, int element) {
        for (int i = offset; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, int offset, byte element) {
        for (int i = offset; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] deleteArea(Class<T> type, T[] elements, int from, int to) {
        int delCount = to - from + 1;
        Object[] newArray = (Object[])Array.newInstance(type, elements.length - delCount);
        System.arraycopy(elements, 0, newArray, 0, from);
        if (to < elements.length - 1) {
            System.arraycopy(elements, to + 1, newArray, from, elements.length - from - delCount);
        }
        return newArray;
    }

    public static <T> T[] insertArea(Class<T> type, Object[] elements, int pos, Object[] add) {
        Object[] newArray = (Object[])Array.newInstance(type, elements.length + add.length);
        System.arraycopy(elements, 0, newArray, 0, pos);
        System.arraycopy(add, 0, newArray, pos, add.length);
        System.arraycopy(elements, pos, newArray, pos + add.length, elements.length - pos);
        return newArray;
    }

    public static <T> T[] add(Class<T> type, T[] elements, T add) {
        Object[] newArray = (Object[])Array.newInstance(type, elements.length + 1);
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        newArray[elements.length] = add;
        return newArray;
    }

    public static <T> T[] remove(Class<T> type, T[] elements, int index) {
        Object[] newArray = (Object[])Array.newInstance(type, elements.length - 1);
        System.arraycopy(elements, 0, newArray, 0, index);
        if (index < elements.length - 1) {
            System.arraycopy(elements, index + 1, newArray, index, elements.length - index - 1);
        }
        return newArray;
    }

    public static <T> T[] remove(Class<T> type, T[] elements, T element) {
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] != element) continue;
            return ArrayUtils.remove(type, elements, i);
        }
        return elements;
    }

    public static int[] add(int[] elements, int add) {
        int[] newArray = new int[elements.length + 1];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        newArray[elements.length] = add;
        return newArray;
    }

    public static <T> T[] toArray(Class<T> type, Collection<? extends T> list) {
        return list.toArray((Object[])Array.newInstance(type, list.size()));
    }

    @Nullable
    public static boolean[] unbox(@Nullable Boolean[] source) {
        if (source == null) {
            return null;
        }
        boolean[] result = new boolean[source.length];
        for (int i = 0; i < source.length; ++i) {
            result[i] = source[i];
        }
        return result;
    }

    public static void reverse(@Nullable Object[] array) {
        if (array == null || array.length <= 1) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }
}

