/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.validator;

import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class DoubleValidator
implements VerifyListener {
    private final double minValue;
    private final double maxValue;
    private final boolean allowNegative;

    public DoubleValidator(double minValue, double maxValue, boolean allowNegative) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.allowNegative = allowNegative;
    }

    public void verifyText(VerifyEvent e) {
        Object object = e.getSource();
        if (object instanceof Text) {
            Text text = (Text)object;
            String current = text.getText();
            String prospective = current.substring(0, e.start) + e.text + current.substring(e.end);
            this.verifyText(e, prospective);
        } else {
            this.verifyText(e, e.text);
        }
    }

    private void verifyText(VerifyEvent e, String text) {
        if (text.isEmpty() || ".".equals(text)) {
            return;
        }
        if (!this.allowNegative && text.startsWith("-")) {
            e.doit = false;
            return;
        }
        try {
            double value = Double.parseDouble(text);
            if (value < this.minValue || value > this.maxValue) {
                e.doit = false;
            }
        }
        catch (NumberFormatException ex) {
            e.doit = false;
        }
    }
}

