/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.layout;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class GraphAnimation {
    static final long DURATION = 400L;
    static long current;
    static double progress;
    static long start;
    static long finish;
    static Viewport viewport;
    static boolean PLAYBACK;
    static boolean RECORDING;
    static Map<IFigure, Object> initialStates;
    static Map<IFigure, Object> finalStates;

    public static void end() {
        for (IFigure f : initialStates.keySet()) {
            f.revalidate();
            f.setVisible(true);
        }
        initialStates = null;
        finalStates = null;
        PLAYBACK = false;
        viewport = null;
    }

    public static boolean captureLayout(IFigure root) {
        RECORDING = true;
        while (!(root instanceof Viewport)) {
            root = root.getParent();
        }
        viewport = (Viewport)root;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        initialStates = new HashMap<IFigure, Object>();
        finalStates = new HashMap<IFigure, Object>();
        root.validate();
        Iterator<IFigure> iter = initialStates.keySet().iterator();
        if (!iter.hasNext()) {
            RECORDING = false;
            return false;
        }
        while (iter.hasNext()) {
            GraphAnimation.recordFinalState(iter.next());
        }
        start = System.currentTimeMillis();
        finish = start + 400L;
        current = start + 20L;
        RECORDING = false;
        PLAYBACK = true;
        return true;
    }

    public static boolean playbackState(Connection conn) {
        if (!PLAYBACK) {
            return false;
        }
        PointList list1 = (PointList)initialStates.get(conn);
        PointList list2 = (PointList)finalStates.get(conn);
        if (list1 == null) {
            conn.setVisible(false);
            return true;
        }
        if (list1.size() == list2.size()) {
            Point pt1 = new Point();
            Point pt2 = new Point();
            PointList points = conn.getPoints();
            points.removeAllPoints();
            for (int i = 0; i < list1.size(); ++i) {
                list1.getPoint(pt2, i);
                list2.getPoint(pt1, i);
                pt1.x = (int)Math.round((double)pt1.x * progress + (1.0 - progress) * (double)pt2.x);
                pt1.y = (int)Math.round((double)pt1.y * progress + (1.0 - progress) * (double)pt2.y);
                points.addPoint(pt1);
            }
            conn.setPoints(points);
        }
        return true;
    }

    public static boolean playbackState(IFigure container) {
        if (!PLAYBACK) {
            return false;
        }
        List children = container.getChildren();
        for (IFigure child : children) {
            Rectangle rect1 = (Rectangle)initialStates.get(child);
            Rectangle rect2 = (Rectangle)finalStates.get(child);
            if (rect2 == null) continue;
            if (rect2.width > rect1.width || rect2.height > rect1.height) {
                child.setBounds(new Rectangle((int)Math.round(progress * (double)rect2.x + (1.0 - progress) * (double)rect1.x), (int)Math.round(progress * (double)rect2.y + (1.0 - progress) * (double)rect1.y), rect2.width, rect2.height));
                continue;
            }
            child.setBounds(new Rectangle((int)Math.round(progress * (double)rect2.x + (1.0 - progress) * (double)rect1.x), (int)Math.round(progress * (double)rect2.y + (1.0 - progress) * (double)rect1.y), (int)Math.round(progress * (double)rect2.width + (1.0 - progress) * (double)rect1.width), (int)Math.round(progress * (double)rect2.height + (1.0 - progress) * (double)rect1.height)));
        }
        return true;
    }

    public static void recordFinalState(Connection conn) {
        PointList points1 = (PointList)initialStates.get(conn);
        PointList points2 = conn.getPoints().getCopy();
        if (points1 != null && points1.size() != points2.size()) {
            Point p = new Point();
            Point q = new Point();
            int size1 = points1.size() - 1;
            int size2 = points2.size() - 1;
            int i1 = size1;
            int i2 = size2;
            double current1 = 1.0;
            double current2 = 1.0;
            double prev1 = 1.0;
            double prev2 = 1.0;
            while (i1 > 0 || i2 > 0) {
                if (Math.abs(current1 - current2) < 0.1 && i1 > 0 && i2 > 0) {
                    prev1 = current1;
                    prev2 = current2;
                    current1 = (double)(--i1) / (double)size1;
                    current2 = (double)(--i2) / (double)size2;
                    continue;
                }
                if (current1 < current2) {
                    points1.getPoint(p, i1);
                    points1.getPoint(q, i1 + 1);
                    p.x = (int)(((double)q.x * (current2 - current1) + (double)p.x * (prev1 - current2)) / (prev1 - current1));
                    p.y = (int)(((double)q.y * (current2 - current1) + (double)p.y * (prev1 - current2)) / (prev1 - current1));
                    points1.insertPoint(p, i1 + 1);
                    prev1 = prev2 = current2;
                    current2 = (double)(--i2) / (double)size2;
                    continue;
                }
                points2.getPoint(p, i2);
                points2.getPoint(q, i2 + 1);
                p.x = (int)(((double)q.x * (current1 - current2) + (double)p.x * (prev2 - current1)) / (prev2 - current2));
                p.y = (int)(((double)q.y * (current1 - current2) + (double)p.y * (prev2 - current1)) / (prev2 - current2));
                points2.insertPoint(p, i2 + 1);
                prev2 = prev1 = current1;
                current1 = (double)(--i1) / (double)size1;
            }
        }
        finalStates.put((IFigure)conn, points2);
    }

    public static void recordFinalState(IFigure child) {
        if (child instanceof Connection) {
            GraphAnimation.recordFinalState((Connection)child);
            return;
        }
        Rectangle rect2 = child.getBounds().getCopy();
        Rectangle rect1 = (Rectangle)initialStates.get(child);
        if (rect1.isEmpty()) {
            rect1.x = rect2.x;
            rect1.y = rect2.y;
            rect1.width = rect2.width;
        }
        finalStates.put(child, rect2);
    }

    public static void recordInitialState(Connection connection) {
        if (!RECORDING) {
            return;
        }
        PointList points = connection.getPoints().getCopy();
        if (points.size() == 2 && points.getPoint(0).equals((Object)Point.SINGLETON.setLocation(0, 0)) && points.getPoint(1).equals((Object)Point.SINGLETON.setLocation(100, 100))) {
            initialStates.put((IFigure)connection, null);
        } else {
            initialStates.put((IFigure)connection, points);
        }
    }

    public static void recordInitialState(IFigure container) {
        if (!RECORDING) {
            return;
        }
        List children = container.getChildren();
        for (IFigure child : children) {
            initialStates.put(child, child.getBounds().getCopy());
        }
    }

    public static void swap() {
        Map<IFigure, Object> temp = finalStates;
        finalStates = initialStates;
        initialStates = temp;
    }

    public static boolean step() {
        current = System.currentTimeMillis() + 30L;
        progress = (double)(current - start) / (double)(finish - start);
        progress = Math.min(progress, 0.999);
        for (IFigure f : initialStates.keySet()) {
            f.revalidate();
        }
        viewport.validate();
        return current < finish;
    }

    static {
        start = -1L;
    }
}

