/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.txn;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.qm.QMExecutionHandler;
import org.jkiss.dbeaver.model.qm.QMTransactionState;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.runtime.qm.DefaultExecutionHandler;
import org.jkiss.dbeaver.ui.AbstractPartListener;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.SharedTextColors;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.querylog.QueryLogThemeSettings;
import org.jkiss.dbeaver.ui.controls.txn.TransactionLogDialog;

public class TransactionMonitorToolbar {
    private static final int MONITOR_UPDATE_DELAY = 250;
    private static final Log log = Log.getLog(TransactionMonitorToolbar.class);
    private static final RGB RGB_DARK_YELLOW = new RGB(128, 128, 0);
    private static final RGB RGB_DARK_GREEN = new RGB(0, 255, 0);
    private IWorkbenchWindow workbenchWindow;

    private TransactionMonitorToolbar(IWorkbenchWindow workbenchWindow) {
        this.workbenchWindow = workbenchWindow;
    }

    private Control createControl(Composite parent) {
        final MonitorPanel monitorPanel = new MonitorPanel(parent);
        AbstractPartListener partListener = new AbstractPartListener(this){

            public void partActivated(IWorkbenchPart part) {
                if (part instanceof DBPContextProvider) {
                    monitorPanel.refresh();
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }
        };
        IWorkbenchPage activePage = this.workbenchWindow.getActivePage();
        if (activePage != null) {
            activePage.addPartListener((IPartListener)partListener);
            monitorPanel.addDisposeListener(arg_0 -> TransactionMonitorToolbar.lambda$createControl$0(activePage, (IPartListener)partListener, arg_0));
        }
        return monitorPanel;
    }

    private static /* synthetic */ void lambda$createControl$0(IWorkbenchPage activePage, IPartListener partListener, DisposeEvent e) {
        activePage.removePartListener(partListener);
    }

    private class MonitorPanel
    extends Composite {
        private QMEventsHandler qmHandler;
        private RefreshJob refreshJob;
        private QMTransactionState txnState;

        MonitorPanel(Composite parent) {
            super(parent, 2048);
            this.setCursor(parent.getDisplay().getSystemCursor(21));
            this.addPaintListener(this::paint);
            this.setBackground(parent.getDisplay().getSystemColor(22));
            this.setToolTipText(CoreMessages.monitor_panel_transaction_monitor_tip);
            this.refreshJob = new RefreshJob(TransactionMonitorToolbar.this, this);
            this.qmHandler = new QMEventsHandler(this);
            QMUtils.registerHandler((QMExecutionHandler)this.qmHandler);
            this.addDisposeListener(e -> {
                QMUtils.unregisterHandler((QMExecutionHandler)this.qmHandler);
                this.qmHandler = null;
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    TransactionLogDialog.showDialog(MonitorPanel.this.getShell(), MonitorPanel.this.getActiveExecutionContext());
                }
            });
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            int fontHeight = UIUtils.getFontHeight((Control)this);
            int panelWidth = fontHeight * 8;
            Point point = super.computeSize(wHint, hHint, changed);
            if (point.x < panelWidth) {
                point.x = panelWidth;
            }
            return point;
        }

        public void setToolTipText(String string) {
            super.setToolTipText(string);
        }

        private void paint(PaintEvent e) {
            Color bg;
            int updateCount;
            int n = updateCount = this.txnState == null ? 0 : this.txnState.getUpdateCount();
            if (this.txnState == null || !this.txnState.isTransactionMode()) {
                bg = UIStyles.getDefaultTextBackground();
            } else if (updateCount == 0) {
                bg = QueryLogThemeSettings.instance.colorTransaction;
            } else {
                SharedTextColors sharedColors = UIUtils.getSharedTextColors();
                Color colorReverted = QueryLogThemeSettings.instance.colorReverted;
                Color colorCommitted = QueryLogThemeSettings.instance.colorUncommitted;
                RGB COLOR_FULL = colorReverted == null ? RGB_DARK_YELLOW : colorReverted.getRGB();
                RGB COLOR_EMPTY = colorCommitted == null ? RGB_DARK_GREEN : colorCommitted.getRGB();
                int minCount = 0;
                int maxCount = 400;
                int ratio = (updateCount - minCount) * 100 / (maxCount - minCount);
                if (updateCount >= maxCount) {
                    bg = sharedColors.getColor(COLOR_FULL);
                } else {
                    RGB rgb = UIUtils.blend((RGB)COLOR_FULL, (RGB)COLOR_EMPTY, (int)ratio);
                    bg = sharedColors.getColor(rgb);
                }
            }
            Rectangle bounds = this.getBounds();
            e.gc.setBackground(bg);
            e.gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
            String count = this.txnState == null ? "N/A" : (!this.txnState.isTransactionMode() ? "Auto" : (updateCount > 0 ? String.valueOf(updateCount) : "None"));
            Point textSize = e.gc.textExtent(count);
            e.gc.setForeground(UIStyles.getDefaultTextForeground());
            e.gc.drawString(count, bounds.x + (bounds.width - textSize.x) / 2 - 2, bounds.y + (bounds.height - textSize.y) / 2 - 1);
        }

        public void refresh() {
            this.refreshJob.schedule(250L);
        }

        void updateTransactionsInfo(DBRProgressMonitor monitor) {
            monitor.beginTask("Extract active transaction info", 1);
            DBCExecutionContext executionContext = this.getActiveExecutionContext();
            this.txnState = executionContext == null ? null : QMUtils.getTransactionState((DBCExecutionContext)executionContext);
            monitor.done();
            UIUtils.asyncExec(() -> {
                if (this.isDisposed()) {
                    return;
                }
                this.redraw();
                this.updateToolTipText();
                ActionUtils.fireCommandRefresh((String[])new String[]{"org.jkiss.dbeaver.core.txn.autocommit"});
            });
        }

        @Nullable
        private DBCExecutionContext getActiveExecutionContext() {
            if (TransactionMonitorToolbar.this.workbenchWindow == null || TransactionMonitorToolbar.this.workbenchWindow.getActivePage() == null) {
                return null;
            }
            DBCExecutionContext executionContext = null;
            IEditorPart activeEditor = TransactionMonitorToolbar.this.workbenchWindow.getActivePage().getActiveEditor();
            if (activeEditor instanceof DBPContextProvider) {
                executionContext = ((DBPContextProvider)activeEditor).getExecutionContext();
            }
            return executionContext;
        }

        private void updateToolTipText() {
            if (this.txnState == null) {
                this.setToolTipText(ModelMessages.error_not_connected_to_database);
            } else if (this.txnState.isTransactionMode()) {
                long txnUptime = this.txnState.getTransactionStartTime() > 0L ? (System.currentTimeMillis() - this.txnState.getTransactionStartTime()) / 1000L + 1L : 0L;
                String toolTip = String.valueOf(this.txnState.getExecuteCount()) + " total statements\n" + String.valueOf(this.txnState.getUpdateCount()) + " modifying statements";
                if (txnUptime > 0L) {
                    toolTip = toolTip + "\n" + String.valueOf(txnUptime) + " seconds uptime";
                }
                this.setToolTipText(toolTip);
            } else {
                this.setToolTipText(CoreMessages.action_menu_transactionMonitor_autocommitMode);
            }
        }
    }

    private static class QMEventsHandler
    extends DefaultExecutionHandler {
        private final MonitorPanel monitorPanel;

        QMEventsHandler(MonitorPanel monitorPanel) {
            this.monitorPanel = monitorPanel;
        }

        @NotNull
        public String getHandlerName() {
            return QMEventsHandler.class.getName();
        }

        private void refreshMonitor() {
            if (!this.monitorPanel.isDisposed()) {
                this.monitorPanel.refresh();
            }
        }

        public synchronized void handleTransactionAutocommit(@NotNull DBCExecutionContext context, boolean autoCommit) {
            this.refreshMonitor();
        }

        public synchronized void handleTransactionCommit(@NotNull DBCExecutionContext context) {
            this.refreshMonitor();
            DBExecUtils.recoverSmartCommit((DBCExecutionContext)context);
        }

        public synchronized void handleTransactionRollback(@NotNull DBCExecutionContext context, DBCSavepoint savepoint) {
            this.refreshMonitor();
            DBExecUtils.recoverSmartCommit((DBCExecutionContext)context);
        }

        public void handleStatementExecuteEnd(@NotNull DBCStatement statement, long rows, Throwable error) {
            this.refreshMonitor();
        }

        public void handleContextOpen(@NotNull DBCExecutionContext context, boolean transactional) {
            this.refreshMonitor();
        }

        public void handleContextClose(@NotNull DBCExecutionContext context) {
            this.refreshMonitor();
        }
    }

    public static class ToolbarContribution
    extends WorkbenchWindowControlContribution {
        public ToolbarContribution() {
            super("dbeaver-transactions");
        }

        protected Control createControl(Composite parent) {
            TransactionMonitorToolbar toolbar = new TransactionMonitorToolbar(UIUtils.getActiveWorkbenchWindow());
            return toolbar.createControl(parent);
        }
    }

    private class RefreshJob
    extends Job {
        private final MonitorPanel monitorPanel;

        RefreshJob(TransactionMonitorToolbar transactionMonitorToolbar, MonitorPanel monitorPanel) {
            super("Refresh transaction monitor");
            this.setSystem(true);
            this.setUser(false);
            this.monitorPanel = monitorPanel;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.monitorPanel.updateTransactionsInfo((DBRProgressMonitor)new DefaultProgressMonitor(monitor));
            }
            catch (Throwable e) {
                log.debug((Object)("Error updating transaction info: " + e.getMessage()));
            }
            return Status.OK_STATUS;
        }
    }
}

