# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network ddos-custom-policy update",
)
class Update(AAZCommand):
    """Update a DDoS custom policy.

    :example: Create DDoS custom policy
        az network ddos-custom-policy update --resource-group rg1 --ddos-custom-policy-name test-ddos-custom-policy --location centraluseuap --detection-rules "[{name:detectionRuleTcp,detection-mode:TrafficThreshold,traffic-detection-rule:{traffic-type:Tcp,packets-per-second:1000000}}]"
    """

    _aaz_info = {
        "version": "2025-03-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/ddoscustompolicies/{}", "2025-03-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.ddos_custom_policy_name = AAZStrArg(
            options=["-n", "--name", "--ddos-custom-policy-name"],
            help="The name of the DDoS custom policy.",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )

        # define Arg Group "Parameters"

        _args_schema = cls._args_schema
        _args_schema.location = AAZResourceLocationArg(
            arg_group="Parameters",
            help="Resource location.",
            nullable=True,
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            arg_group="Parameters",
            help="Resource tags.",
            nullable=True,
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg(
            nullable=True,
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.detection_rules = AAZListArg(
            options=["--detection-rules"],
            arg_group="Properties",
            help="The list of DDoS detection rules associated with the custom policy.",
            nullable=True,
        )

        detection_rules = cls._args_schema.detection_rules
        detection_rules.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.detection_rules.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the DDoS detection rule.",
            nullable=True,
        )
        _element.detection_mode = AAZStrArg(
            options=["detection-mode"],
            help="The detection mode for the DDoS detection rule.",
            nullable=True,
            enum={"TrafficThreshold": "TrafficThreshold"},
        )
        _element.traffic_detection_rule = AAZObjectArg(
            options=["traffic-detection-rule"],
            help="The traffic detection rule details.",
            nullable=True,
        )

        traffic_detection_rule = cls._args_schema.detection_rules.Element.traffic_detection_rule
        traffic_detection_rule.packets_per_second = AAZIntArg(
            options=["packets-per-second"],
            help="The customized packets per second threshold.",
            nullable=True,
        )
        traffic_detection_rule.traffic_type = AAZStrArg(
            options=["traffic-type"],
            help="The traffic type (one of Tcp, Udp, TcpSyn) that the detection rule will be applied upon.",
            nullable=True,
            enum={"Tcp": "Tcp", "TcpSyn": "TcpSyn", "Udp": "Udp"},
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.DdosCustomPoliciesGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.vars.instance)
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.vars.instance)
        yield self.DdosCustomPoliciesCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_update(self, instance):
        pass

    @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class DdosCustomPoliciesGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosCustomPolicies/{ddosCustomPolicyName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "ddosCustomPolicyName", self.ctx.args.ddos_custom_policy_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2025-03-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_ddos_custom_policy_read(cls._schema_on_200)

            return cls._schema_on_200

    class DdosCustomPoliciesCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosCustomPolicies/{ddosCustomPolicyName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "ddosCustomPolicyName", self.ctx.args.ddos_custom_policy_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2025-03-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _UpdateHelper._build_schema_ddos_custom_policy_read(cls._schema_on_200_201)

            return cls._schema_on_200_201

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.vars.instance)

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("location", AAZStrType, ".location")
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("detectionRules", AAZListType, ".detection_rules")

            detection_rules = _builder.get(".properties.detectionRules")
            if detection_rules is not None:
                detection_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.detectionRules[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.detectionRules[].properties")
            if properties is not None:
                properties.set_prop("detectionMode", AAZStrType, ".detection_mode")
                properties.set_prop("trafficDetectionRule", AAZObjectType, ".traffic_detection_rule")

            traffic_detection_rule = _builder.get(".properties.detectionRules[].properties.trafficDetectionRule")
            if traffic_detection_rule is not None:
                traffic_detection_rule.set_prop("packetsPerSecond", AAZIntType, ".packets_per_second")
                traffic_detection_rule.set_prop("trafficType", AAZStrType, ".traffic_type")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.vars.instance,
                self.ctx.generic_update_args
            )


class _UpdateHelper:
    """Helper class for Update"""

    _schema_ddos_custom_policy_read = None

    @classmethod
    def _build_schema_ddos_custom_policy_read(cls, _schema):
        if cls._schema_ddos_custom_policy_read is not None:
            _schema.etag = cls._schema_ddos_custom_policy_read.etag
            _schema.id = cls._schema_ddos_custom_policy_read.id
            _schema.location = cls._schema_ddos_custom_policy_read.location
            _schema.name = cls._schema_ddos_custom_policy_read.name
            _schema.properties = cls._schema_ddos_custom_policy_read.properties
            _schema.tags = cls._schema_ddos_custom_policy_read.tags
            _schema.type = cls._schema_ddos_custom_policy_read.type
            return

        cls._schema_ddos_custom_policy_read = _schema_ddos_custom_policy_read = AAZObjectType()

        ddos_custom_policy_read = _schema_ddos_custom_policy_read
        ddos_custom_policy_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        ddos_custom_policy_read.id = AAZStrType()
        ddos_custom_policy_read.location = AAZStrType()
        ddos_custom_policy_read.name = AAZStrType(
            flags={"read_only": True},
        )
        ddos_custom_policy_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        ddos_custom_policy_read.tags = AAZDictType()
        ddos_custom_policy_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_ddos_custom_policy_read.properties
        properties.detection_rules = AAZListType(
            serialized_name="detectionRules",
        )
        properties.front_end_ip_configuration = AAZListType(
            serialized_name="frontEndIpConfiguration",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )

        detection_rules = _schema_ddos_custom_policy_read.properties.detection_rules
        detection_rules.Element = AAZObjectType()

        _element = _schema_ddos_custom_policy_read.properties.detection_rules.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType(
            flags={"read_only": True},
        )
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_ddos_custom_policy_read.properties.detection_rules.Element.properties
        properties.detection_mode = AAZStrType(
            serialized_name="detectionMode",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.traffic_detection_rule = AAZObjectType(
            serialized_name="trafficDetectionRule",
        )

        traffic_detection_rule = _schema_ddos_custom_policy_read.properties.detection_rules.Element.properties.traffic_detection_rule
        traffic_detection_rule.packets_per_second = AAZIntType(
            serialized_name="packetsPerSecond",
        )
        traffic_detection_rule.traffic_type = AAZStrType(
            serialized_name="trafficType",
        )

        front_end_ip_configuration = _schema_ddos_custom_policy_read.properties.front_end_ip_configuration
        front_end_ip_configuration.Element = AAZObjectType()

        _element = _schema_ddos_custom_policy_read.properties.front_end_ip_configuration.Element
        _element.id = AAZStrType()

        tags = _schema_ddos_custom_policy_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_ddos_custom_policy_read.etag
        _schema.id = cls._schema_ddos_custom_policy_read.id
        _schema.location = cls._schema_ddos_custom_policy_read.location
        _schema.name = cls._schema_ddos_custom_policy_read.name
        _schema.properties = cls._schema_ddos_custom_policy_read.properties
        _schema.tags = cls._schema_ddos_custom_policy_read.tags
        _schema.type = cls._schema_ddos_custom_policy_read.type


__all__ = ["Update"]
